<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bank_details', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('account_holder_name');
            $table->string('ifsc_code');
            $table->string('account_number');
            $table->string('branch');
            $table->string('bank_name');
            $table->string('type')->default(value: 'user');
            $table->boolean('is_active')->default(1); 
            $table->string('upi_id')->nullable();
            $table->string('image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bank_details');
    }
};
