<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('withdraw_requests', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('bank_id')->nullable();
            $table->decimal('amount', 10, 2);
            $table->string('status')->default('requested'); 
            $table->boolean('is_active')->default(0);
            $table->string(column: 'type');
            $table->string(column: 'gpay_number')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('withdraw_requests');
    }
};
