<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shop_wallet_incomes', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('membership_id')->nullable();
            $table->float('amount', 15, 2)->default(0);
            $table->string('remark');
            $table->boolean('is_active')->default(1);
            $table->string('type');
               $table->string('payment_mode')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shop_wallet_incomes');
    }
};
