<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bill_items', function (Blueprint $table) {
            $table->id();
              $table->foreignId('bill_id')->constrained('bills')->onDelete('cascade');
            $table->foreignId('product_id')->nullable()->constrained('products')->onDelete('set null');
            $table->foreignId('product_variant_id')->nullable()->constrained('product_varients')->onDelete('set null'); // Note: your model is ProductVarient
            $table->string('item_name');
            $table->string('item_code')->nullable();
            $table->decimal('mrp', 10, 2);
            $table->decimal('sell_price', 10, 2);
            $table->integer('quantity');
            $table->decimal('gst_percentage', 5, 2)->default(0.00);
            $table->decimal('cgst_percentage', 5, 2)->default(0.00);
            $table->decimal('sgst_percentage', 5, 2)->default(0.00);
            $table->decimal('item_discount_amount', 10, 2)->default(0.00); // Discount applied to this specific item
            $table->decimal('total_amount', 10, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bill_items');
    }
};
