<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMyPurchasesTable extends Migration
{
    public function up()
    {
        Schema::create('my_purchases', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_purchase_id'); 
            $table->string('invoice_number')->unique();
            $table->date('purchase_date');
            $table->decimal('discount_amount', 10, 2)->default(0);
            $table->string('discount_note')->nullable();
            $table->decimal('additional_charge', 10, 2)->default(0);
            $table->string('additional_charge_note')->nullable();
            $table->decimal('gst_total', 10, 2);
            $table->decimal('sub_total_excluding_gst', 10, 2);
            $table->decimal('sub_total_including_gst', 10, 2);
            $table->decimal('total_amount', 10, 2);
            $table->string('branch')->nullable();
            $table->string('print_type')->nullable();
            $table->timestamps();

            // ✅ Ensure referenced table exists before this
            $table->foreign('product_purchase_id')
                  ->references('id')->on('product_purchases')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('my_purchases');
    }
}
