<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMyPurchaseItemsTable extends Migration
{
    public function up()
    {
        Schema::create('my_purchase_items', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Required for foreign keys in MySQL

            $table->id();
            $table->unsignedBigInteger('my_purchase_id');
            $table->unsignedBigInteger('product_id');

            $table->integer('quantity');
            $table->decimal('purchase_price', 10, 2);
            $table->decimal('sell_price', 10, 2);
            $table->decimal('gst_percentage', 5, 2)->default(0);
            $table->decimal('cgst', 5, 2)->default(0);
            $table->decimal('sgst', 5, 2)->default(0);
            $table->timestamps();

            // ✅ Correct foreign keys
            $table->foreign('my_purchase_id')
                  ->references('id')->on('my_purchases')
                  ->onDelete('cascade');

            $table->foreign('product_id')
                  ->references('id')->on('products')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('my_purchase_items');
    }
}
