<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_summaries', function (Blueprint $table) {
            $table->id();
             $table->string('product_id'); 
            $table->string('transaction_type'); 
            $table->string('quantity', 10, 2);
            $table->text('order_id')->nullable();
            $table->string('closing_stock');
            $table->string('stock');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_summaries');
    }
};
