<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    // public function run(): void
    // {
    //     $data               = new User();
    //     $data->name         = "admin";
    //     $data->user_id      = "Admin001";
    //     $data->email        = "admin@gmail.com";
    //     $data->phone_number = "9443595313";
    //     $data->is_active    = "1";
    //     $data->role         = "admin";
    //     $data->otp            = Crypt::encryptString('123456');
    //     $data->otp_expires_at = Carbon::now()->addMinutes(5);
    //     $data->house_no      = "123";
    //     $data->building_name = "ABC Building";
    //     $data->road_name     = "Main Road";
    //     $data->landmark      = "Near Bus Stand";
    //     $data->district      = "Nagercoil";
    //     $data->state         = "Tamil Nadu";
    //     $data->pin           = "629001";
    //     $data->password      = Hash::make('admin');
    //     $data->save();
    // }

public function run(): void
{
    User::create([
        'name'             => 'Main Admin',
        'user_id'          => 'Admin100',
        'email'            => 'admin10@gmail.com',
        'phone_number'     => '9443505310',
        'is_active'        => 1,
        'role'             => 'admin',
        'otp'              => Crypt::encryptString('123456'),
        'otp_expires_at'   => Carbon::now()->addMinutes(5),
        'house_no'         => "123",
        'building_name'    => "ABC Building",
        'road_name'        => "Main Road",
        'landmark'         => "Near Bus Stand",
        'district'         => "Nagercoil",
        'state'            => "Tamil Nadu",
        'pin'              => "629001",
        'password'         => Hash::make('admin'),
    ]);

    $admins = [
        [
            'name'         => 'Sakthi Admin',
            'user_id'      => 'Sakthi1001',
            'email'        => 'admin1@gmail.com',
            'phone_number' => '9443595313',
            'role'         => 'sakthi',
            'password'     => 'admin1',
        ],
        [
            'name'         => 'Smart World Admin',
            'user_id'      => 'SmartWorld001',
            'email'        => 'admin2@gmail.com',
            'phone_number' => '9443595314',
            'role'         => 'smart_world',
            'password'     => 'admin2',
        ],
        [
            'name'         => 'Smart World Gift Admin',
            'user_id'      => 'SmartWorldGift001',
            'email'        => 'admin3@gmail.com',
            'phone_number' => '9443595315',
            'role'         => 'smart_world_gift',
            'password'     => 'admin3',
        ],
        [
            'name'         => 'Yoga Naturals Admin',
            'user_id'      => 'YogaNaturals001',
            'email'        => 'admin4@gmail.com',
            'phone_number' => '9443595316',
            'role'         => 'yoga_naturals',
            'password'     => 'admin4',
        ],
    ];

    foreach ($admins as $admin) {
        User::create([
            'name'             => $admin['name'],
            'user_id'          => $admin['user_id'],
            'email'            => $admin['email'],
            'phone_number'     => $admin['phone_number'],
            'is_active'        => 1,
            'role'             => $admin['role'],
            'otp'              => Crypt::encryptString('123456'),
            'otp_expires_at'   => Carbon::now()->addMinutes(5),
            'house_no'         => "123",
            'building_name'    => "ABC Building",
            'road_name'        => "Main Road",
            'landmark'         => "Near Bus Stand",
            'district'         => "Nagercoil",
            'state'            => "Tamil Nadu",
            'pin'              => "629001",
            'password'         => Hash::make($admin['password']),
        ]);
    }
}

}
