<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BankSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $banks = [
            'State Bank of India',
            'Punjab National Bank',
            'HDFC Bank',
            'ICICI Bank',
            'Axis Bank',
            'Bank of Baroda',
            'Canara Bank',
            'Bank of India',
            'Union Bank of India',
            'Indian Bank',
            'IDBI Bank',
            'Central Bank of India',
            'Indian Overseas Bank',
            'UCO Bank',
            'Punjab & Sind Bank',
            'Bank of Maharashtra',
            'Yes Bank',
            'Kotak Mahindra Bank',
            'IndusInd Bank',
            'Federal Bank',
            'South Indian Bank',
            'RBL Bank',
            'Karur Vysya Bank',
            'Bandhan Bank',
            'DCB Bank',
            'City Union Bank',
            'Jammu & Kashmir Bank',
            'Tamilnad Mercantile Bank',
            'AU Small Finance Bank',
            'Equitas Small Finance Bank',
            'Ujjivan Small Finance Bank',
            'North East Small Finance Bank',
            'Suryoday Small Finance Bank',
            'Fincare Small Finance Bank',
            'ESAF Small Finance Bank',
            'Capital Small Finance Bank',
            'Paytm Payments Bank',
            'Airtel Payments Bank',
            'India Post Payments Bank'
        ];

        foreach ($banks as $bank) {
            DB::table('banks')->insert([
                'name' => $bank,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
    }
}
