<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us – AdBazzar</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.7;
            color: #343a40; /* Darker text for readability */
            background-color: #f8f9fa; /* Light grey background */
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Montserrat', sans-serif;
            color: #138FA6 !important; /* AdBazzar brand color */
        }
        .container {
            flex: 1; /* Allows content to push footer down */
            background-color: #ffffff;
            border-radius: 0.75rem; /* Slightly more rounded corners */
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.08); /* Enhanced shadow */
            padding: 2.5rem; /* Increased padding */
            margin-top: 3rem;
            margin-bottom: 3rem;
        }
        .hero-section {
            background-color: #138FA6;
            color: #fff;
            padding: 4rem 2rem; /* More vertical padding */
            border-radius: 0.75rem 0.75rem 0 0; /* Rounded top corners only */
            margin-bottom: 2.5rem;
            text-align: center;
        }
        .hero-section h1 {
            font-size: clamp(2.5rem, 5vw, 3.5rem); /* Responsive font size */
            font-weight: 700;
            margin-bottom: 1rem;
            color: #fff !important;
        }
        .hero-section p {
            font-size: clamp(1rem, 2.5vw, 1.25rem); /* Responsive font size */
            opacity: 0.95;
            max-width: 800px;
            margin-left: auto;
            margin-right: auto;
        }
        .section-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 0.75rem;
            font-size: 1.6em;
            color: #138FA6;
        }
        p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }
        ul {
            list-style-type: none;
            padding-left: 0;
        }
        ul li {
            margin-bottom: 0.6rem;
            font-size: 1.05rem;
            position: relative;
            padding-left: 1.8rem; /* Space for custom bullet */
        }
        ul li::before {
            content: "\f24c"; /* Bootstrap icon for info-circle-fill */
            font-family: "bootstrap-icons";
            color: #138FA6;
            font-weight: bold;
            display: inline-block;
            position: absolute;
            left: 0;
            top: 0.1em;
            font-size: 1.1em;
        }
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.05); /* Lighter shadow for cards */
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            margin-bottom: 1.5rem;
        }
        .card:hover {
            transform: translateY(-0.25rem);
            box-shadow: 0 0.5rem 1.25rem rgba(0, 0, 0, 0.09);
        }
        .footer {
            margin-top: 3rem;
            padding: 1.5rem;
            text-align: center;
            color: #6c757d;
            font-size: 0.875rem;
            background-color: #e9ecef; /* Light grey footer */
            border-top: 1px solid #dee2e6;
        }

        /* Responsive adjustments */
        @media (max-width: 767.98px) {
            .container {
                margin-top: 1.5rem;
                margin-bottom: 1.5rem;
                padding: 1.5rem;
                border-radius: 0; /* Remove border-radius on small screens for full width */
                box-shadow: none; /* Remove shadow on small screens */
            }
            .hero-section {
                padding: 3rem 1rem;
                border-radius: 0;
            }
            .hero-section h1 {
                font-size: 2rem;
            }
            .hero-section p {
                font-size: 0.95rem;
            }
            .section-title {
                font-size: 1.5rem;
                justify-content: center; /* Center align title and icon on mobile */
                text-align: center;
            }
            ul li {
                padding-left: 1.5rem; /* Adjust padding for smaller screens */
            }
            ul li::before {
                font-size: 1em;
                left: 0; /* Keep icon left-aligned */
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="hero-section rounded-top">
            <h1 class="mb-3 animate__animated animate__fadeInDown">Welcome to AdBazzar!</h1>
            <p class="lead animate__animated animate__fadeInUp">Your ultimate destination for affordable shopping and rewarding experiences.</p>
        </div>

        <div class="card p-4 animate__animated animate__fadeIn">
            <p>AdBazzar was founded in <strong>2025</strong> with a vision to make online shopping <strong>affordable and rewarding for everyone</strong>. Our primary goal is to offer quality products at competitive prices while empowering individuals, especially homemakers, to earn wallet rewards through our unique membership model.</p>
            <p>Users can join our <strong>Membership Plan</strong>, complete simple daily tasks, and earn wallet rewards. These rewards can be used for up to <strong>10%–50% of the product price</strong> while purchasing items through our app, helping reduce out-of-pocket expenses.</p>
            <p>Through our system, we aim to support families with practical savings and income opportunities in a safe and convenient way. We believe in providing accessible value for all kinds of consumers with transparency and reliability.</p>
        </div>

        <div class="card p-4 mt-4 animate__animated animate__fadeInUp">
            <h2 class="section-title text-center text-md-start"><i class="bi bi-building"></i>Company Details:</h2>
            <ul class="list-unstyled">
                <li><strong>Company Name:</strong> AdBazzar</li>
                <li><strong>Founded:</strong> 2025</li>
                <li><strong>Mission:</strong> To make shopping affordable and enable income through simple task-based rewards.</li>
            </ul>
        </div>
    </div>

    <footer class="footer">
        &copy; 2025 AdBazzar. All rights reserved.
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>