@extends('admin.layouts')
@section('title', 'Recent Orders')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
    <style>
        .badge {
            font-size: 12px;
            padding: 4px 8px;
        }
        #data-table td:last-child,
#data-table th:last-child {
    width: 120px;
    white-space: nowrap;
    text-align: center;
}

    </style>
@endsection
@section('content')



    <div class="container-fluid page-wrapper">



        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Accepted Orders</h3>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-3">
                <label for="fromDate">From Date</label>
                <input type="date" id="fromDate" class="form-control">
            </div>
            <div class="col-md-3">
                <label for="toDate">To Date</label>
                <input type="date" id="toDate" class="form-control">
            </div>
            <div class="col-md-3">
                <button id="filterBtn" class="btn btn-primary mt-4">Filter</button>
                <button id="resetBtn" class="btn btn-secondary mt-4 ml-2">Reset</button>
            </div>
        </div>



        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                       <table id="data-table" class="table align-middle" style="width:100%">

                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER DETAILS</th>
                                 
                                    <th>PRODUCT DETAILS</th>
                                    <th>AMOUNT</th>
                                    <th>SHIPROCKET ORDER ID</th>
                                    <th>SHIPMENT ID</th>
                                    <th>SHIPROCKECT STATUS</th>
                                    <th>ACTION </th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($recent_orders as $key => $recent_order)
                                    <tr
                                        data-order-date="{{ \Carbon\Carbon::parse($recent_order->order_date)->format('YYYY-MM-DD') }}">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ \Carbon\Carbon::parse($recent_order->order_date)->format('d-m-Y') }}</td>
                                        <td>{{ $recent_order->order_random_id }}</td>
                                        <td>
                                            <div>User ID: {{ $recent_order->user_id ?? 'NA' }}</div>
                                            <div>{{ $recent_order->user_name }}</div>
                                        </td>

                                       
                                        @php
                                            $categories =
                                                json_decode($recent_order->category_name, true) ??
                                                explode('~', $recent_order->category_name);
                                            $subcategories =
                                                json_decode($recent_order->subcategory_name, true) ??
                                                explode('~', $recent_order->subcategory_name);
                                            $product_details_name =
                                                json_decode($recent_order->product_details_name, true) ??
                                                explode('~', $recent_order->product_details_name);
                                        @endphp
                                        <td>{{ implode(', ', array_map('trim', $product_details_name)) }}</td>
                                        </td>
                                        <td><span>₹{{ $recent_order->amount }}</span></td>
                                        <td>{{ $recent_order->shiprocket_order_id ? $recent_order->shiprocket_order_id : '-' }}
                                        </td>
                                        <td>{{ $recent_order->shipment_id ? $recent_order->shipment_id : '-' }}</td>
                                        <td>{{ $recent_order->status }}</td>
                                          <td>
                                            <a href="{{ route('view_recent_orders', ['order_random_id' => $recent_order->order_random_id]) }}"
                                                class="btn btn-primary btn-sm">
                                                <i class="fa-regular fa-eye me-2"></i>View Order
                                            </a>

                                        </td>

                                    </tr>

                                @endforeach
                            </tbody>
                        </table>


                    </div>
                </div>
            </div>
        </div>
    </div>




@endsection
@section('footer')


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

    <script>
        $(document).ready(function() {
            let table = $('#data-table').DataTable({
                responsive: true
            });

            // Custom date filter function
            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                let fromDate = $('#fromDate').val();
                let toDate = $('#toDate').val();
                let orderDate = data[1]; // ORDER DATE column (index 1)

                let momentDate = moment(orderDate, 'D-M-YYYY');

                if (fromDate && !momentDate.isSameOrAfter(fromDate, 'day')) {
                    return false;
                }

                if (toDate && !momentDate.isSameOrBefore(toDate, 'day')) {
                    return false;
                }

                return true;
            });

            // Filter button event
            $('#filterBtn').on('click', function() {
                table.draw();
            });

            // Reset button event
            $('#resetBtn').on('click', function() {
                $('#fromDate').val('');
                $('#toDate').val('');
                table.draw();
            });
        });
    </script>


@endsection
