@extends('admin.layouts')
@section('title', 'Notification')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">


        <div class="d-flex align-items-center justify-content-between">
            <h3 class="page-top-heading">Add Bank</h3>
        </div>


        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header">
                        <h5 class="card-title">Add Bank</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('add_bank_details') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">

                                    <div class="form-group mb-3">
                                        <label for="account_holder_name" class="form-label">Account Holder Name</label>
                                        <input type="text" name="account_holder_name" class="form-control"
                                            id="account_holder_name" placeholder="Enter Account Holder Name">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="bank_name" class="form-label">Bank Name</label>
                                        <input type="text" name="bank_name" class="form-control" id="bank_name"
                                            placeholder="Enter Bank Name">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="branch" class="form-label">Branch</label>
                                        <input type="text" name="branch" class="form-control" id="branch"
                                            placeholder="Enter Branch Name">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="ifsc_code" class="form-label">IFSC Code</label>
                                        <input type="text" name="ifsc_code" class="form-control" id="ifsc_code"
                                            placeholder="Enter IFSC Code">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="account_number" class="form-label">Account Number</label>
                                        <input type="text" name="account_number" class="form-control" id="account_number"
                                            placeholder="Enter Account Number">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="upi_id" class="form-label">UPI ID</label>
                                        <input type="text" name="upi_id" class="form-control" id="upi_id"
                                            placeholder="Enter UPI ID">
                                    </div>

                                    <!-- QR Code Image Upload Field -->
                                    <div class="form-group mb-3">
                                        <label for="qr_code" class="form-label">QR Code Image</label>
                                        <input type="file" name="image" class="form-control" id="image"
                                            accept="image/*">
                                    </div>


                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>

                </div>
            </div>
        </div>


        <!-- Table Row -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="mb-3">
                    <h6 class="table-heading">History</h6>
                </div>
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Account Holder</th>
                                    <th>Bank Name</th>
                                    <th>Branch</th>
                                    <th>IFSC</th>
                                    <th>Account Number</th>
                                    <th>UPI ID</th>
                                    <th>QR Code</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($bankDetails as $index => $bank)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $bank->account_holder_name }}</td>
                                        <td>{{ $bank->bank_name }}</td>
                                        <td>{{ $bank->branch }}</td>
                                        <td>{{ $bank->ifsc_code }}</td>
                                        <td>{{ $bank->account_number }}</td>
                                        <td>{{ $bank->upi_id }}</td>
                                        <td>
                                            @if ($bank->image)
                                                <img src="{{ asset($bank->image) }}" width="50" alt="QR Code">
                                            @else
                                                N/A
                                            @endif
                                        </td>

                                        <td class="d-flex gap-3 align-items-center">
                                            <!-- Edit Icon -->
                                            <a href="{{ route('edit_bank', $bank->id) }}" title="Edit">
                                                <i class="fa fa-edit text-primary"></i>
                                            </a>

                                            <!-- Toggle Status Icon -->
                                            <a href="javascript:void(0);" data-bs-toggle="modal"
                                                data-bs-target="#statusModal{{ $bank->id }}"
                                                title="{{ $bank->is_active ? 'Deactivate' : 'Activate' }}">
                                                <i
                                                    class="fa {{ $bank->is_active ? 'fa-eye-slash' : 'fa-eye' }} text-{{ $bank->is_active ? 'success' : 'secondary' }}"></i>
                                            </a>

                                            <!-- Delete Icon -->
                                            <a href="javascript:void(0);" data-bs-toggle="modal"
                                                data-bs-target="#deleteModal{{ $bank->id }}" title="Delete">
                                                <i class="fa fa-trash text-danger"></i>
                                            </a>
                                        </td>

                                    </tr>
                                    <!-- Toggle Status Modal -->
                                    <div class="modal fade" id="statusModal{{ $bank->id }}" tabindex="-1"
                                        aria-labelledby="statusModalLabel{{ $bank->id }}" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <form action="{{ route('toggle_bank_status', $bank->id) }}" method="POST">
                                                @csrf
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="statusModalLabel{{ $bank->id }}">
                                                            Change Status</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Are you sure you want to change the status
                                                        <strong>{{ $bank->account_holder_name }}</strong>?
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Cancel</button>
                                                        <button type="submit"
                                                            class="btn {{ $bank->is_active ? 'btn-danger' : 'btn-success' }}">
                                                            Yes, {{ $bank->is_active ? 'Deactivate' : 'Activate' }}
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>


                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->
        @foreach ($bankDetails as $bank)
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal{{ $bank->id }}" tabindex="-1"
                aria-labelledby="deleteModalLabel{{ $bank->id }}" aria-hidden="true">
                <div class="modal-dialog">
                    <form action="{{ route('delete_bank', $bank->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteModalLabel{{ $bank->id }}">Confirm Delete</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                Are you sure you want to delete bank detail for
                                <strong>{{ $bank->account_holder_name }}</strong>?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-danger">Yes, Delete</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        @endforeach

    </div>
    <!-- end container fluid -->




@endsection
@section('footer')


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        function setDeleteId(button) {
            var deleteId = button.getAttribute('data-user-id');
            document.getElementById('delete_id').value = deleteId;
        }
    </script>


@endsection
