@extends('admin.layouts')
@section('title', 'Employee')
@section('header')
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-oBqDVmMz4fnFO9t5a6P6A6O6A0p3U7v38wzA1N39N7Jt6jvNIi2B2i+1DkF1Vr" crossorigin="anonymous"></script>
@endsection
@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Employee</h3>
            </div>
        </div>
        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header">
                        <h5 class="card-title">Add Employee</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('employee_store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="col-lg-6">
                                        {{-- <div class="form-group mb-3">
                                            <label for="branch_id" class="form-label">
                                                Select Branch <span style="color: red;">*</span>
                                            </label>
                                            @if (auth()->user()->role === 'admin')
                                                <select name="branch_id" id="branch_id" class="form-control" required>
                                                    <option value="">-- Select Branch --</option>
                                                    @foreach ($branches as $branch)
                                                        <option value="{{ $branch->id }}"
                                                            {{ old('branch_id', auth()->user()->branch_id ?? '') == $branch->id ? 'selected' : '' }}>
                                                            {{ $branch->branch_name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            @elseif (in_array(auth()->user()->role, ['sakthi', 'smart_world', 'smart_world_gift', 'yoga_naturals']))
                                                @php
                                                    $roleToBranchName = [
                                                        'sakthi'           => 'Sakthi Super Mart',
                                                        'smart_world'      => 'SMARTWORLD',
                                                        'smart_world_gift' => 'SMARTWORLD - Stationary & Gifts',
                                                        'yoga_naturals'    => 'Yogaa Naturals',
                                                    ];
                                                    $userRole = auth()->user()->role;
                                                    $branchName = $roleToBranchName[$userRole] ?? null;
                                                    $userBranch = $branches->firstWhere('branch_name', $branchName);
                                                @endphp
                                                <input type="hidden" name="branch_id"
                                                    value="{{ $userBranch ? $userBranch->id : '' }}">
                                                <input type="text" class="form-control"
                                                    value="{{ $branchName ?? 'Unknown Branch' }}" readonly>
                                            @else
                                                <input type="text" class="form-control" value="Unknown Role or Branch"
                                                    readonly>
                                            @endif
                                        </div> --}}
                                        <div class="form-group mb-3">
    {{-- <label for="branch_id" class="form-label">
        Select Branch <span style="color: red;">*</span>
    </label> --}}
      <label class="form-label">Branch</label>
        <input type="text" 
               class="form-control" 
               value="{{ strtoupper(auth()->user()->name) }}" 
               disabled>
    
    @if (auth()->user()->role === 'admin')
        <!-- Visible only for Admin -->
        <select name="branch_id" id="branch_id" class="form-control" required>
            <option value="">-- Select Branch --</option>
            @foreach ($branches as $branch)
                <option value="{{ $branch->id }}"
                    {{ old('branch_id', auth()->user()->branch_id ?? '') == $branch->id ? 'selected' : '' }}>
                    {{ $branch->branch_name }}
                </option>
            @endforeach
        </select>

    @else
        <!-- Other roles hidden completely (no input, no readonly) -->
        <input type="hidden" name="branch_id" value="{{ auth()->user()->branch_id }}">
    @endif
</div>

                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" name="name" class="form-control" id="name">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="designation" class="form-label">Email</label>
                                        <input type="text" name="email" class="form-control" id="designation">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="name" class="form-label">Password</label>
                                        <input type="text" name="password" class="form-control" id="name">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="designation" class="form-label">Designation</label>
                                        <input type="text" name="designation" class="form-control" id="designation">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="phone" class="form-label">Phone Number</label>
                                        <input type="text" name="phone" class="form-control" id="phone">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="address" class="form-label">Address</label>
                                        <input type="text" name="address" class="form-control" id="address">
                                    </div>
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="mb-3">
                    <h6 class="table-heading">Employee List</h6>
                </div>
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Date</th>
                                    <th>Branch</th>
                                    <th>Designation</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($employees as $index => $employee)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ \Carbon\Carbon::parse($employee->created_at)->format('d-M-Y') }}</td>
                                        <td>{{ $employee->branch }}</td>
                                        <td>{{ $employee->designation }}</td>
                                        <td>{{ $employee->name }}</td>
                                        <td>{{ $employee->phone }}</td>
                                        <td>{{ $employee->address }}</td>
                                        <td>
                                            <a href="{{ route('edit_employee', $employee->id) }}"
                                                class="btn btn-sm btn-primary">
                                                Edit
                                            </a>
                                            <button type="button" data-bs-toggle="modal"
                                                data-bs-target="#DeleteModal-{{ $employee->id }}"
                                                class="btn transparent-btn text-danger text-decoration-underline">Delete</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">No employees found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @foreach ($employees as $employeeItem)
            <div class="modal fade zoom-in" id="DeleteModal-{{ $employeeItem->id }}" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="p-3">
                                        <div class="text-center">
                                            <img class="mb-3"
                                                src="{{ asset('/assets/images/icons/delete-icon.svg') }}">
                                            <p class="my-4 are-you-sure">Are You Sure?</p>
                                            <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to delete
                                                this employee?</p>
                                        </div>
                                        <div class="d-flex align-items-center mt-5 mb-3">
                                            <button data-bs-dismiss="modal"
                                                class="btn btn-light cancel-btn me-3">Cancel</button>
                                            <a href="{{ route('employee_delete', $employeeItem->id) }}"
                                                class="btn btn-primary yes-btn"><i
                                                    class="fa-regular fa-circle-check me-2"></i>Yes, Delete It!</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection
@section('footer')
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const deleteButtons = document.querySelectorAll('.deleteBtn');
            const deleteForm = document.getElementById('deleteEmployeeForm');
            deleteButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const employeeId = this.getAttribute('data-id');
                    deleteForm.setAttribute('action', '/employee/delete/' + employeeId);
                });
            });
        });
    </script>
    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>
@endsection
