@extends('admin.layouts')
@section('title', 'Add Category')
@section('header')
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
@endsection

@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center justify-content-between">
                   <h3 class="page-top-heading">Add User</h3>
                <p class="page-top-heading">User ID-{{ $nextUserId }}</p>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Add User</h5>
                    </div>
                    <div class="card-body">
                      
                        <form action="{{ route('users_store') }}" method="POST" autocomplete="off">
                            @csrf
                            <div class="row">
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Name" required autocomplete="off">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" placeholder="Enter Email" required autocomplete="off">
                            </div>
                           
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" class="form-control" name="password" placeholder="Enter Password" required autocomplete="off">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Confirm Password</label>
                                <input type="password" class="form-control" name="password_confirmation" placeholder="Enter Confirm Password" required autocomplete="off">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Membership Plan(Optional)</label>
                                <select class="form-control" name="membership_id" >
                                    <option value="">Select Membership</option>
                                    @foreach ($memberships as $membership)
                                        <option value="{{ $membership->id }}">{{ $membership->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                           <div class="col-lg-6 mb-3">
    <label class="form-label">Payment Mode</label>
    <input type="text" class="form-control" name="payment_mode" placeholder="Enter Payment Mode">
</div>


                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Referral Id (Optional)</label>
                                <input type="text" class="form-control" name="referral_id" placeholder="Enter Referral ID (if available)">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Phone Number</label>
                                <input type="text" class="form-control" name="phone" placeholder="Enter Phone Number" >
                            </div>
                            {{-- <div class="col-lg-6 mb-3">
                                <label class="form-label">address</label>
                                <input type="text" class="form-control" name="address" placeholder="Enter address" >
                            </div>
                             --}}
                        </div>
                        <div class="d-flex justify-content-center mt-2">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                            
                        </form>
                        
                        
                        
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->
    </div>
    <!-- end container fluid -->
@endsection

    
@section('footer')

@endsection
