@extends('admin.layouts')
@section('title', 'Bill Wise Profit')
@section('header')
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/responsive.bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/buttons.dataTables.min.css') }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="{{ asset('/assets/css/formILY.css') }}">
@endsection
@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Bill Wise Profit</h3>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <button class="btn btn-success mb-3" id="downloadExcelBtn">Export to Excel</button>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="fromDate">From Date:</label>
                    <input type="date" class="form-control" id="fromDate">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="toDate">To Date:</label>
                    <input type="date" class="form-control" id="toDate">
                </div>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                <button class="btn btn-secondary" id="resetBtn">Reset</button>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12">
                <div id="totalAmountDisplay" class="total-amount-display">
                </div>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table class="table table-bordered" id="salesTable">
                            <thead class="table-light">
                                <tr>
                                    <th>S.NO</th>
                                    <th>DATE</th>
                                    <th>INVOICE NO</th>
                                    <th>CUSTOMER NAME</th>
                                    <th>PURCHASE AMOUNT</th>
                                    <th>INVOICE AMOUNT</th>
                                    <th>PAYABLE AMOUNT</th>
                                    <th>CASH WALLET AMOUNT</th>
                                    <th>SHOPP WALLET AMOUNT</th>
                                    <th>PROFIT</th>
                                    <th class="exclude-export">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
    @foreach ($offlineSales as $key => $sale)
        <tr>
            <td>{{ $key + 1 }}</td>
            <td>{{ $sale->created_at->format('d-m-Y') }}</td>
            <td>{{ $sale->order_id }}</td>
            <td>{{ $sale->customer_details['name'] ?? 'N/A' }}</td>
            <td>₹ {{ number_format($sale->purchase_amount, 2) }}</td>
            <td>₹ {{ number_format($sale->total_amount ?? 0, 2) }}</td>
            <td>₹ {{ number_format($sale->amount_payable ?? 0, 2) }}</td>
            <td>₹ {{ number_format($sale->cash_wallet_deduction ?? 0, 2) }}</td>
            <td>₹ {{ number_format($sale->shopping_wallet_deduction ?? 0, 2) }}</td>
            <td>₹ {{ number_format($sale->netprofit, 2) }}</td>
            <td>
                <a href="{{ url('admin/bill_invoice_a4/' . $sale->order_id) }}" 
                   target="_blank" class="btn btn-info btn-sm">
                   View Invoice
                </a>
            </td>
        </tr>
    @endforeach
</tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('/assets/js/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/vfs_fonts.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#salesTable').DataTable({
        responsive: true,
        dom: 'frtip',
        buttons: [{
            extend: 'excelHtml5',
            className: 'buttons-excel',
            exportOptions: {
                columns: ':visible:not(.exclude-export)'
            }
        }]
    });
    // Hide built-in Excel button
    table.buttons(0, null).container().hide();
    // Custom Excel export button
    $('#downloadExcelBtn').on('click', function() {
        table.button('.buttons-excel').trigger();
    });
    // ✅ Filter Button Click – Reload Page with Date Params
    $('#filterBtn').on('click', function() {
        const fromDate = $('#fromDate').val();
        const toDate = $('#toDate').val();
        if (!fromDate || !toDate) {
            alert('Please select both From Date and To Date.');
            return;
        }
        window.location.href = `?from=${fromDate}&to=${toDate}`;
    });
    // ✅ Reset Button Click – Reload Default Current Month View
    $('#resetBtn').on('click', function() {
        window.location.href = window.location.pathname;
    });
    // ✅ Detect browser refresh and reset to default (current month view)
    if (performance.navigation.type === performance.navigation.TYPE_RELOAD) {
        window.location.href = window.location.pathname;
    }
    // ✅ Total Profit Display Calculation
    function updateTotalProfit() {
        let totalProfit = 0;
        table.rows({ search: 'applied' }).every(function() {
            let data = this.data();
            let profitText = data[9].replace(/[₹, ]/g, '');
            let profit = parseFloat(profitText);
            if (!isNaN(profit)) {
                totalProfit += profit;
            }
        });
        $('#totalAmountDisplay').html(
            '<h5><b>Total Profit: ₹ ' +
            totalProfit.toLocaleString(undefined, { minimumFractionDigits: 2 }) +
            '</b></h5>'
        );
    }
    // Initial total calculation
    updateTotalProfit();
});
</script>
@endsection
