@extends('admin.layouts')
@section('title', 'User Management')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Cash Wallet Transaction </h3>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="fromDate">From Date:</label>
                    <input type="date" class="form-control" id="fromDate">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="toDate">To Date:</label>
                    <input type="date" class="form-control" id="toDate">
                </div>
            </div>
            <div class="col-md-6 d-flex align-items-end justify-content-end">
                <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                <button class="btn btn-secondary" id="resetBtn">Reset</button>
            </div>
        </div>
        <div class="row mt-3">
    <div class="col-md-12">
        <div class="total-amount-container">
            <strong>Total Amount:</strong> <span id="totalAmount"></span>
        </div>
    </div>
</div>

        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>DATE</th>
                                    <th>NAME</th>
                                    <th>USER ID</th>
                                    <th>NUMBER</th>
                                    <th>MEMBERSHIP</th>
                                    <th>TYPE</th>
                                    <th>AMOUNT</th>
                                    <th>REMARK</th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($cashWalletTransactions as $index => $cashWalletTransaction)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $cashWalletTransaction->created_at->format('Y-m-d H:i:s') }}</td>
                                        <td>{{ optional($cashWalletTransaction->user)->name ?? 'N/A' }}</td>
                                        <td>{{ optional($cashWalletTransaction->user)->user_id ?? 'N/A' }}</td>
                                        <td>{{ optional($cashWalletTransaction->user)->phone_number ?? 'N/A' }}</td>
                                        <td>{{ optional($cashWalletTransaction->user)->membership ?? 'N/A' }}</td>
                                     <td>{{ $cashWalletTransaction->type ?? 'N/A' }}</td>
                                        
                                        <td>{{ number_format($cashWalletTransaction->amount, 2) }}</td>
                                    <td>{{ $cashWalletTransaction->remark ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>




@endsection
@section('footer')

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    {{-- <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script> --}}
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

    <script>
        function setAcceptId(element) {
            document.getElementById("accept_id").value = element.getAttribute("data-user-id");
        }

        function setRejectId(element) {
            document.getElementById("reject_id").value = element.getAttribute("data-user-id");
        }
</script>

{{-- <script>
      $(document).ready(function() {
    let table = $('#data-table').DataTable({
        dom: 'Bfrtip',
        buttons: [{
            extend: 'excelHtml5',
            text: 'Export to Excel',
            filename: 'Cash_Wallet_Transactions',
            title: null,
            className: 'd-none',
            exportOptions: {
                columns: ':visible'
            }
        }],
        responsive: true
    });

    // Export to Excel
    $('.excel-btn').on('click', function() {
        table.button('.buttons-excel').trigger();
    });

    // Add custom filtering for date range
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
        let fromDate = $('#fromDate').val();
        let toDate = $('#toDate').val();
        let date = data[1]; // DATE column
        let amount = parseFloat(data[7].replace(/[^0-9.-]+/g, "")); // Extract amount value

        // If no dates are selected, show all rows
        if (!fromDate && !toDate) {
            return true;
        }

        // Parse the date from the table row (data[1]) and selected date fields
        let momentDate = moment(date, 'YYYY-MM-DD HH:mm:ss'); // Adjust if the date format in table is different
        let fromMoment = fromDate ? moment(fromDate) : null;
        let toMoment = toDate ? moment(toDate) : null;

        // Check if the date falls within the selected range
        if (fromDate && !toMoment && momentDate.isSameOrAfter(fromMoment, 'day')) {
            return true;
        }

        if (!fromMoment && toDate && momentDate.isSameOrBefore(toMoment, 'day')) {
            return true;
        }

        if (fromMoment && toMoment && momentDate.isSameOrAfter(fromMoment, 'day') && momentDate
            .isSameOrBefore(toMoment, 'day')) {
            return true;
        }

        return false;
    });

    // Apply the filter when the 'Filter' button is clicked
    $('#filterBtn').on('click', function() {
        table.draw();
        updateTotalAmount(table);
    });

    // Reset the filters when the 'Reset' button is clicked
    $('#resetBtn').on('click', function() {
        $('#fromDate').val('');
        $('#toDate').val('');
        table.draw();
        updateTotalAmount(table);
    });

    // Function to update the total amount displayed
    function updateTotalAmount(table) {
        let totalAmount = 0;
        // Loop through the table rows and calculate the total amount based on filtered data
        table.rows({ search: 'applied' }).every(function() {
            let row = this.node();
            let amount = parseFloat($(row).find('td').eq(7).text().replace(/[^0-9.-]+/g, "")); // Amount column
            totalAmount += isNaN(amount) ? 0 : amount;
        });
        // Update the displayed total amount
        $('#totalAmount').text(totalAmount.toFixed(2));
    }
});


</script> --}}

<script>
    $(document).ready(function() {
        let table = $('#data-table').DataTable({
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excelHtml5',
                text: 'Export to Excel',
                filename: 'Cash_Wallet_Transactions',
                title: null,
                className: 'd-none',
                exportOptions: {
                    columns: ':visible'
                }
            }],
            responsive: true
        });

        // **Call updateTotalAmount initially when the page loads**
        updateTotalAmount(table);

        // Export to Excel
        $('.excel-btn').on('click', function() {
            table.button('.buttons-excel').trigger();
        });

        // Add custom filtering for date range
        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
            let fromDate = $('#fromDate').val();
            let toDate = $('#toDate').val();
            let date = data[1]; // DATE column

            // If no dates are selected, show all rows
            if (!fromDate && !toDate) {
                return true;
            }

            // Parse the date from the table row (data[1]) and selected date fields
            let momentDate = moment(date, 'YYYY-MM-DD HH:mm:ss'); // Adjust if the date format in table is different
            let fromMoment = fromDate ? moment(fromDate) : null;
            let toMoment = toDate ? moment(toDate) : null;

            // Check if the date falls within the selected range
            if (fromDate && !toMoment && momentDate.isSameOrAfter(fromMoment, 'day')) {
                return true;
            }

            if (!fromMoment && toDate && momentDate.isSameOrBefore(toMoment, 'day')) {
                return true;
            }

            if (fromMoment && toMoment && momentDate.isSameOrAfter(fromMoment, 'day') && momentDate
                .isSameOrBefore(toMoment, 'day')) {
                return true;
            }

            return false;
        });

        // Apply the filter when the 'Filter' button is clicked
        $('#filterBtn').on('click', function() {
            table.draw();
            updateTotalAmount(table);
        });

        // Reset the filters when the 'Reset' button is clicked
        $('#resetBtn').on('click', function() {
            $('#fromDate').val('');
            $('#toDate').val('');
            table.draw();
            updateTotalAmount(table);
        });

        // Function to update the total amount displayed
        function updateTotalAmount(table) {
            let totalAmount = 0;
            // Loop through the table rows and calculate the total amount based on filtered data
            table.rows({ search: 'applied' }).every(function() {
                let row = this.node();
                let amount = parseFloat($(row).find('td').eq(7).text().replace(/[^0-9.-]+/g, "")); // Amount column
                totalAmount += isNaN(amount) ? 0 : amount;
            });
            // Update the displayed total amount
            $('#totalAmount').text(totalAmount.toFixed(2));
        }
    });
</script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

@endsection
