@extends('admin.layouts')
@section('title', 'Notification')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">

@endsection
@section('content')



<div class="container-fluid page-wrapper category-container">

   
    <div class="d-flex align-items-center justify-content-between">
        <h3 class="page-top-heading">Create Plan</h3>
        
        <!-- History Button -->
        <a href="{{ route('create_plan_history') }}" class="btn btn-primary">
            <i class="fa fa-history me-1"></i> View History
        </a>
    </div>
    

    <div class="row d-flex justify-content-center mt-4">
        <div class="col-lg-6">
            <div class="card ILY-form-card">
                <div class="card-header">
                    <h5 class="card-title">Create Plan</h5>
                </div>
                <div class="card-body">
                    
                    <form action="{{ route('create_plan') }}" method="POST" enctype="multipart/form-data">
                        @csrf  
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group mb-3">
                                    <label for="cover_image" class="form-label">Choose Image</label>
                                    <input class="form-control" name="cover_image" type="file" id="cover_image" accept="image/*">

                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="title" class="form-label">Membership Name</label>
                                    <input type="text" name="title" class="form-control" id="title" placeholder="Enter name" required>
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="amount" class="form-label">Membership Fee</label>
                                    <input type="number" name="amount" class="form-control" id="amount" placeholder="Enter fee" required>
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="welcome_bonus" class="form-label">Welcome Bonus</label>
                                    <input type="number" name="welcome_bonus" class="form-control" id="welcome_bonus" placeholder="Enter amount" required>
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="daily_reward" class="form-label">Daily Rewards Amount</label>
                                    <input type="number" name="daily_reward" class="form-control" id="daily_reward" placeholder="Enter amount" required>
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="referral_percentage" class="form-label">Referral Benefit (%)</label>
                                    <input type="number" name="referral_percentage" class="form-control" id="referral_percentage" placeholder="Enter percentage" required>
                                </div>
                    
                                <div class="button-container mt-4">
                                    <button type="submit" class="btn btn-primary submit-btn">
                                        <i class="fa-regular fa-circle-check me-2"></i> Submit
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                    
                     
                </div>
            </div>
        </div>
    </div>

   
   
    
</div>
<!-- end container fluid -->




@endsection
@section('footer')


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function setDeleteId(button) {
        var deleteId = button.getAttribute('data-user-id');
        document.getElementById('delete_id').value = deleteId;
    }
</script>
@endsection


