@extends('admin.layouts')
@section('title', 'User Management')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Create Plan  History</h3>
                
            </div>
        </div>
       
       

        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Title</th>
                                    <th>Amount</th>
                                    <th>Welcome Bonus</th>
                                    <th>Daily Reward</th>
                                    <th>Referral Percentage</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($memberships as $membership)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $membership->title }}</td>
                                    <td>{{ number_format($membership->amount, 2) }}</td>
                                    <td>{{ number_format($membership->welcome_bonus, 2) }}</td>
                                    <td>{{ number_format($membership->daily_reward, 2) }}</td>
                                    <td>{{ $membership->referral_percentage }}%</td>
                                    <td>
                                       
                                        <a href="{{ route('edit_plan', $membership->id) }}" class="btn btn-primary">Edit</a>

                                        <button type="button" class="btn btn-danger" data-bs-toggle="modal" 
                                                data-bs-target="#deleteModal" 
                                                onclick="setDeleteId({{ $membership->id }})">
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="POST" action="{{ route('plan_delete') }}">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="membership_id" id="deleteMembershipId">
                            Are you sure you want to delete this membership plan?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <script>
        function setDeleteId(id) {
            document.getElementById("deleteMembershipId").value = id;
        }
        </script>
        



 <!-- Delete Modal for Each Notification -->
 <div class="modal fade" id="DeleteModalcc" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
          
            <div class="modal-body">
                <div class="text-center">
                   
                    <img class="mb-3" src="{{ asset('/assets') }}/images/icons/delete-icon.svg" alt="Delete Icon">
                    <p class="my-4">Are You Sure?</p>
                    <p class="text-muted my-2">Are you sure you want to delete this notification?</p>
                </div>
                <form action="{{ route('plan_delete') }}" method="POST">
                    @csrf
                    <input type="hidden" id="delete_id" name="delete_id">
                    <div class="d-flex align-items-center mt-5 mb-3">
                        <button type="button" data-bs-dismiss="modal" class="btn btn-light cancel-btn me-3">Cancel</button>
                        <button type="submit" class="btn btn-primary submit-btn"><i class="fa-regular fa-circle-check me-2"></i>Submit</button>
                    </div>
                </form>
                
            </div>
        </div>
    </div>
</div>


    </div>
    <!-- end container fluid -->




@endsection
@section('footer')

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>


    
    <script>
        function setDeleteId(id) {
            document.getElementById("deleteMembershipId").value = id;
        }
        </script>
@endsection
