@extends('admin.layouts')
@section('title', 'User Management')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
<style>
    table td, table th {
    vertical-align: top;
    white-space: normal !important;
    word-wrap: break-word;
}

</style>
@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Daily Task History</h3>

            </div>
        </div>



        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        {{-- <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Date</th>
                                    <th>Video Link</th>
                                    <th>Note</th>
                                    <th>Time</th>
                                    <th>Cover Image</th>
                                    
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($datatables as $data)
                                    <tr>

                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $data->date }}</td>
                                        <td>{{ $data->video_link }}</td>
                                        <td>{{ $data->note }}</td>
                                        <td>{{ $data->time }}</td>
                                        <td>
                                            @if (!empty($data->cover_image))
                                            <img src="{{ asset($data->cover_image) }}" class="preview-td-img" alt="preview image">
                                        @else
                                            <span>null</span>
                                        @endif
                                        </td>
                                      
                                        <td>
                                            <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModalcc"
                                                class="btn transparent-btn text-danger text-decoration-underline"
                                                data-user-id="{{ $data->id }}" onclick="setDeleteId(this)">
                                                Delete
                                            </button>

                                            <a href="{{ route('edit_daily_task', ['id' => $data->id]) }}"
                                                class="btn transparent-btn text-primary text-decoration-underline">
                                                Edit
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table> --}}

<table id="data-table" class="table align-middle" style="width:100%">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Date</th>
            <th>Video Link</th>
            <th>Note</th>
            <th>Time</th>
            <th>Cover Image</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($datatables as $data)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $data->date }}</td>

                <td style="word-break: break-all; max-width: 200px;">
                    {{ $data->video_link }}
                </td>

                <td style="white-space: normal; max-width: 250px;">
                    {{ $data->note }}
                </td>

                <td>{{ $data->time }}</td>

                <td>
                    @if (!empty($data->cover_image))
                        <img src="{{ asset($data->cover_image) }}" class="preview-td-img" alt="preview image" style="max-width: 100px; height: auto;">
                    @else
                        <span>null</span>
                    @endif
                </td>

                <td>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModalcc"
                        class="btn transparent-btn text-danger text-decoration-underline"
                        data-user-id="{{ $data->id }}" onclick="setDeleteId(this)">
                        Delete
                    </button>

                    <a href="{{ route('edit_daily_task', ['id' => $data->id]) }}"
                        class="btn transparent-btn text-primary text-decoration-underline">
                        Edit
                    </a>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>


                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->



        <!-- Delete Modal for Each Notification -->
        <div class="modal fade" id="DeleteModalcc" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                    <div class="modal-body">
                        <div class="text-center">

                            <img class="mb-3" src="{{ asset('/assets') }}/images/icons/delete-icon.svg"
                                alt="Delete Icon">
                            <p class="my-4">Are You Sure?</p>
                            <p class="text-muted my-2">Are you sure you want to delete this notification?</p>
                        </div>
                        <form action="{{ route('video_delete') }}" method="POST">
                            @csrf
                            <input type="hidden" id="delete_id" name="delete_id">
                            <div class="d-flex align-items-center mt-5 mb-3">
                                <button type="button" data-bs-dismiss="modal"
                                    class="btn btn-light cancel-btn me-3">Cancel</button>
                                <button type="submit" class="btn btn-primary submit-btn"><i
                                        class="fa-regular fa-circle-check me-2"></i>Submit</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>


    </div>
    <!-- end container fluid -->




@endsection
@section('footer')

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>


    <script>
        function setDeleteId(button) {
            var userId = button.getAttribute("data-user-id");
            document.getElementById("delete_id").value = userId; // Set ID correctly
        }
    </script>

@endsection
