@extends('admin.layouts')
@section('title', 'User Management')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Daily Transaction History </h3>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
            </div>
            <div class="row mt-3">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="fromDate">From Date:</label>
                        <input type="date" class="form-control" id="fromDate">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="toDate">To Date:</label>
                        <input type="date" class="form-control" id="toDate">
                    </div>
                </div>
                <div class="col-md-6 d-flex align-items-end justify-content-end">
                    <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                    <button class="btn btn-secondary" id="resetBtn">Reset</button>
                </div>
            </div>
            <div class="row mt-4">
    <div class="col-md-12">
        <div id="totalAmountDisplay" class="total-amount-display">
            <!-- Total Amount will be displayed here -->
        </div>
    </div>
</div>

            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card datatable-card">
                        <div class="card-body">
                            <table id="data-table" class="table nowrap align-middle" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>NAME</th>
                                        <th>USER ID</th>
                                        <th>DATE</th>
                                        <th>MEMBERSHIP</th>
                                         <th>PAYMENT MODE</th>
                                         <th>AMOUNT</th>
                                        <th>REMARK</th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($transactions as $index => $transaction)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ optional($transaction->user)->name ?? 'N/A' }}</td>
                                            <td>{{ optional($transaction->user)->user_id ?? 'N/A' }}</td>
                                            <td>{{ $transaction->created_at->format('Y-m-d H:i:s') }}</td>
                                            <td>{{ optional($transaction->user)->membership ?? 'N/A' }}</td>
                                            <td>{{ $transaction->payment_mode }}</td>
                                            <td>{{ number_format($transaction->amount, 2) }}</td>
                                            <td>{{ $transaction->remark }}</td>
                                        </tr>
                                    @endforeach

                                    @if ($transactions->isEmpty())
                                        <tr>
                                            <td colspan="7" class="text-center">No transactions found</td>
                                        </tr>
                                    @endif
                                </tbody>

                            </table>
                      
                        </div>
                    </div>
                </div>
            </div>
        </div>




    @endsection
    @section('footer')

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <!-- JQuery CDN -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"
            integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

        <!-- Datatable JS -->
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
        {{-- <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script> --}}
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
        <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

        <script>
            function setAcceptId(element) {
                document.getElementById("accept_id").value = element.getAttribute("data-user-id");
            }

            function setRejectId(element) {
                document.getElementById("reject_id").value = element.getAttribute("data-user-id");
            }
        </script>

        <script>
    $(document).ready(function() {
        let table = $('#data-table').DataTable({
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excelHtml5',
                text: 'Export to Excel',
                filename: 'daily_Transactions',
                title: null,
                className: 'd-none',
                exportOptions: {
                    columns: ':visible'
                }
            }],
            responsive: true
        });

        // Function to calculate and display the total amount for filtered rows
        function calculateTotalAmount() {
            let totalAmount = 0;

            // Loop through the filtered rows and calculate the total amount
            // The column index for 'AMOUNT' is 6 (0-indexed) based on your HTML table structure.
            table.rows({ search: 'applied' }).every(function() {
                let row = this.node();
                let amount = parseFloat($(row).find('td').eq(6).text().replace(/,/g, ''));
                if (!isNaN(amount)) {
                    totalAmount += amount;
                }
            });

            // Display the total amount
            $('#totalAmountDisplay').text('Total Amount: ' + totalAmount.toFixed(2));
        }

        // --- Initial Calculation on Page Load ---
        // Call the function immediately to display the total amount when the page loads
        // (before any filters are applied).
        calculateTotalAmount();

        // --- Event Listeners ---

        // Trigger total calculation whenever the table is redrawn (e.g., after applying filters, pagination).
        table.on('draw', function() {
            calculateTotalAmount();
        });

        // Handle filter button click
        $('#filterBtn').on('click', function() {
            table.draw(); // Redraw the table to apply the filter
        });

        // Handle reset button click
        $('#resetBtn').on('click', function() {
            $('#fromDate').val('');
            $('#toDate').val('');
            table.draw(); // Redraw the table to reset the filter
        });

        // Handle Excel export button click
        $('.excel-btn').on('click', function() {
            table.button('.buttons-excel').trigger();
        });

        // --- Date Range Filtering Logic for DataTables ---
        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
            let fromDate = $('#fromDate').val();
            let toDate = $('#toDate').val();
            let date = data[3]; // Column 3 is the "DATE" column (0-indexed)

            // If no date filters are set, show all rows
            if (!fromDate && !toDate) {
                return true;
            }

            // Parse the date from the table row and the selected date inputs
            let momentDate = moment(date, 'YYYY-MM-DD HH:mm:ss');
            let fromMoment = fromDate ? moment(fromDate) : null;
            let toMoment = toDate ? moment(toDate) : null;

            // Apply filtering logic
            if (fromDate && !toMoment && momentDate.isSameOrAfter(fromMoment, 'day')) {
                return true;
            }

            if (!fromMoment && toDate && momentDate.isSameOrBefore(toMoment, 'day')) {
                return true;
            }

            if (fromMoment && toMoment && momentDate.isSameOrAfter(fromMoment, 'day') && momentDate.isSameOrBefore(toMoment, 'day')) {
                return true;
            }

            return false;
        });
    });
</script>


        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

    @endsection
