<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete User – AdBazzar</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.7;
            color: #343a40;
            background-color: #f8f9fa;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Montserrat', sans-serif;
            color: #138FA6 !important;
        }
        .container {
            flex: 1;
            background-color: #ffffff;
            border-radius: 0.75rem;
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.08);
            padding: 2.5rem;
            margin-top: 3rem;
            margin-bottom: 3rem;
        }
        .header-title {
            font-size: clamp(2rem, 4vw, 3rem);
            font-weight: 700;
            margin-bottom: 2.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #e9ecef;
        }
        .section-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 0.75rem;
            font-size: 1.6em;
            color: #138FA6;
        }
        p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }
        ul {
            list-style-type: none;
            padding-left: 0;
        }
        ul li {
            margin-bottom: 0.6rem;
            font-size: 1.05rem;
            position: relative;
            padding-left: 1.8rem;
        }
        ul li::before {
            content: "\f24c";
            font-family: "bootstrap-icons";
            color: #138FA6;
            font-weight: bold;
            display: inline-block;
            position: absolute;
            left: 0;
            top: 0.1em;
            font-size: 1.1em;
        }
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.05);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            margin-bottom: 1.5rem;
        }
        .card:hover {
            transform: translateY(-0.25rem);
            box-shadow: 0 0.5rem 1.25rem rgba(0, 0, 0, 0.09);
        }
        a {
            color: #138FA6;
            text-decoration: none;
            font-weight: 500;
        }
        a:hover {
            text-decoration: underline;
        }
        .footer {
            margin-top: 3rem;
            padding: 1.5rem;
            text-align: center;
            color: #6c757d;
            font-size: 0.875rem;
            background-color: #e9ecef;
            border-top: 1px solid #dee2e6;
        }
        @media (max-width: 767.98px) {
            .container {
                margin-top: 1.5rem;
                margin-bottom: 1.5rem;
                padding: 1.5rem;
                border-radius: 0;
                box-shadow: none;
            }
            .header-title {
                font-size: 1.8rem;
                text-align: center;
                margin-bottom: 2rem;
            }
            .section-title {
                font-size: 1.5rem;
                justify-content: center;
                text-align: center;
            }
            ul li {
                padding-left: 1.5rem;
            }
            ul li::before {
                font-size: 1em;
                left: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="header-title text-center">Delete User – AdBazzar</h1>

        <!-- Privacy Policy Cards (unchanged) -->
        
{{-- Show success or error message --}}
@if(session('success'))
    <div class="alert alert-success mt-2">{{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert alert-danger mt-2">{{ session('error') }}</div>
@endif
        <!-- Delete User Form Section -->
        <div class="card p-4 mb-4">
            <h2 class="section-title text-center text-md-start">
                <i class="bi bi-person-x-fill"></i>Delete User by Phone Number
            </h2>
          <form action="{{ route('user_delete_post') }}" method="POST">
    @csrf
    <div class="mb-3">
        <label for="phone" class="form-label">Enter User Phone Number</label>
        <input type="text" class="form-control" id="phone" name="phone" placeholder="e.g., 9876543210" required>
    </div>
    <button type="submit" class="btn btn-danger">
        <i class="bi bi-trash-fill"></i> Delete User
    </button>
</form>



        </div>

       
    </div>

    <footer class="footer">
        &copy; 2025 AdBazzar. All rights reserved. Your privacy matters to us.
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
