@extends('admin.layouts')
@section('title', 'Edit Bank')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">

@endsection
@section('content')

<div class="container-fluid page-wrapper category-container">
    <div class="d-flex align-items-center justify-content-between">
        <h3 class="page-top-heading">Edit Bank</h3>
    </div>
    <div class="row d-flex justify-content-center mt-4">
        <div class="col-lg-6">
            <div class="card ILY-form-card">
                <div class="card-header">
                    <h5 class="card-title">Edit Bank</h5>
                </div>
                <div class="card-body">
                     <form action="{{ route('update_bank', $bank->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group mb-3">
                                    <label for="account_holder_name" class="form-label">Account Holder Name</label>
                                    <input type="text" name="account_holder_name" class="form-control" id="account_holder_name"
                                           placeholder="Enter Account Holder Name"
                                           value="{{ old('account_holder_name', $bank->account_holder_name) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="bank_name" class="form-label">Bank Name</label>
                                    <input type="text" name="bank_name" class="form-control" id="bank_name"
                                           placeholder="Enter Bank Name"
                                           value="{{ old('bank_name', $bank->bank_name) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="branch" class="form-label">Branch</label>
                                    <input type="text" name="branch" class="form-control" id="branch"
                                           placeholder="Enter Branch Name"
                                           value="{{ old('branch', $bank->branch) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="ifsc_code" class="form-label">IFSC Code</label>
                                    <input type="text" name="ifsc_code" class="form-control" id="ifsc_code"
                                           placeholder="Enter IFSC Code"
                                           value="{{ old('ifsc_code', $bank->ifsc_code) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="account_number" class="form-label">Account Number</label>
                                    <input type="text" name="account_number" class="form-control" id="account_number"
                                           placeholder="Enter Account Number"
                                           value="{{ old('account_number', $bank->account_number) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="upi_id" class="form-label">UPI ID</label>
                                    <input type="text" name="upi_id" class="form-control" id="upi_id"
                                           placeholder="Enter UPI ID"
                                           value="{{ old('upi_id', $bank->upi_id) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="qr_code" class="form-label">QR Code Image</label>
                                    <input type="file" name="image" class="form-control" id="image" accept="image/*">
                                    @if ($bank->image)
                                        <img src="{{ asset($bank->image) }}" width="100" class="mt-2" alt="QR Code Preview">
                                    @endif
                                </div>
                                <div class="button-container mt-4">
                                    <button type="submit" class="btn btn-primary submit-btn">
                                        <i class="fa-regular fa-circle-check me-2"></i>Update
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                    
                </div>
             
            </div>
        </div>
    </div>

</div>
<!-- end container fluid -->




@endsection
@section('footer')


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function setDeleteId(button) {
        var deleteId = button.getAttribute('data-user-id');
        document.getElementById('delete_id').value = deleteId;
    }
</script>


@endsection


