@extends('admin.layouts')
@section('title', 'Notification')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">

@endsection
@section('content')



<div class="container-fluid page-wrapper category-container">

   
    <div class="d-flex align-items-center justify-content-between">
        <h3 class="page-top-heading">Daily Task</h3>
        
        <!-- History Button -->
        <a href="{{ route('daily_task_history') }}" class="btn btn-primary">
            <i class="fa fa-history me-1"></i> View History
        </a>
    </div>
    

    <div class="row d-flex justify-content-center mt-4">
        <div class="col-lg-6">
            <div class="card ILY-form-card">
                <div class="card-header">
                    <h5 class="card-title">Edit Daily Task</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('update_dailytask', $video->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                    
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group mb-3">
                                    <label for="date" class="form-label">Date</label>
                                    <input type="date" name="date" class="form-control" id="date" value="{{ old('date', isset($video) ? $video->date : '') }}">
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="task" class="form-label">Task</label>
                                    <input type="text" name="task" class="form-control" id="task" value="{{ old('task', isset($video) ? $video->task : '') }}">
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="note" class="form-label">Note</label>
                                    <input type="text" name="note" class="form-control" id="note" value="{{ old('note', isset($video) ? $video->note : '') }}">
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="video_link" class="form-label">Video Link</label>
                                    <textarea name="video_link" class="form-control" id="video_link" rows="3">{{ old('video_link', isset($video) ? $video->video_link : '') }}</textarea>
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="time" class="form-label">Time Limit (hh:mm:ss)</label>
                                    <input type="text" name="time" class="form-control" id="time" placeholder="HH:MM:SS" value="{{ old('time', isset($video) ? $video->time : '') }}">
                                </div>
                    
                                <div class="form-group mb-3">
                                    <label for="cover_image" class="form-label">Choose Cover Image</label>
                                    <input type="file" name="cover_image" class="form-control" id="cover_image">
                                    {{-- @if(isset($video) && $video->cover_image)
                                        <img src="{{ asset('uploads/videos/'.$video->cover_image) }}" width="100" class="mt-2">
                                    @endif --}}
                                    <img src="{{ asset($video->cover_image) }}" width="100" class="mt-2">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="telegram_link" class="form-label">Telegram Link</label>
                                    <input name="telegram_link" class="form-control" id="telegram_link" rows="3"  value="{{ old('telegram_link', isset($video) ? $video->telegram_link : '') }}">
                                </div>
                            
                                <div class="form-group mb-3">
                                    <label for="youtube_link" class="form-label">YouTube Link</label>
                                    <input name="youtube_link" class="form-control" id="youtube_link" rows="3"  value="{{ old('youtube_link', isset($video) ? $video->youtube_link : '') }}">
                                </div>
                            
                                <div class="form-group mb-3">
                                    <label for="facebook_link" class="form-label">Whatsapp Link</label>
                                    <input name="facebook_link" class="form-control" id="facebook_link" rows="3"  value="{{ old('facebook_link', isset($video) ? $video->facebook_link : '') }}">
                                </div>
                            
                                <div class="form-group mb-3">
                                    <label for="instagram_link" class="form-label">Instagram Link</label>
                                    <input name="instagram_link" class="form-control" id="instagram_link" rows="3"  value="{{ old('instagram_link', isset($video) ? $video->instagram_link : '') }}">
                                </div>

                                <div class="button-container mt-4">
                                    <button type="submit" class="btn btn-primary submit-btn">
                                        <i class="fa-regular fa-circle-check me-2"></i> {{ isset($video) ? 'Update' : 'Submit' }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
    </div>

   
   
    
</div>
<!-- end container fluid -->




@endsection
@section('footer')


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function setDeleteId(button) {
        var deleteId = button.getAttribute('data-user-id');
        document.getElementById('delete_id').value = deleteId;
    }
</script>
@endsection


