@extends('admin.layouts')
@section('title', 'Edit Employee')
@section('header')
    <!-- DataTable CSS -->
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/responsive.bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/buttons.dataTables.min.css') }}">
    <!-- Page CSS -->
    <link rel="stylesheet" href="{{ asset('/assets/css/formILY.css') }}">
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-oBqDVmMz4fnFO9t5a6P6A6O6A0p3U7v38wzA1N39N7Jt6jvNIi2B2i+1DkF1Vr"
        crossorigin="anonymous"></script>
@endsection
@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Edit Employee</h3>
            </div>
        </div>
        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header">
                        <h5 class="card-title">Edit Employee</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('employee.update', $employee->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="col-lg-6">
                                        {{-- <div class="form-group mb-3">
                                            <label for="branch_id" class="form-label">
                                                Select Branch <span style="color: red;">*</span>
                                            </label>
                                            @if (auth()->user()->role === 'admin')
                                                <select name="branch_id" id="branch_id" class="form-control" required>
                                                    <option value="">-- Select Branch --</option>
                                                    @foreach ($branches as $branch)
                                                        <option value="{{ $branch->id }}"
                                                            {{ old('branch_id', $employee->branch_id) == $branch->id ? 'selected' : '' }}>
                                                            {{ $branch->branch_name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            @elseif (in_array(auth()->user()->role, ['sakthi', 'smart_world', 'smart_world_gift', 'yoga_naturals']))
                                                @php
                                                    $roleToBranchName = [
                                                        'sakthi' => 'Sakthi Super Mart',
                                                        'smart_world' => 'SMARTWORLD',
                                                        'smart_world_gift' => 'SMARTWORLD - Stationary & Gifts',
                                                        'yoga_naturals' => 'Yogaa Naturals',
                                                    ];
                                                    $userRole = auth()->user()->role;
                                                    $branchName = $roleToBranchName[$userRole] ?? null;
                                                    $userBranch = $branches->firstWhere('branch_name', $branchName);
                                                @endphp
                                                <input type="hidden" name="branch_id" value="{{ $userBranch->id ?? '' }}">
                                                <input type="text" class="form-control"
                                                    value="{{ $branchName ?? 'Unknown Branch' }}" readonly>
                                            @else
                                                <input type="text" class="form-control" value="Unknown Role or Branch" readonly>
                                            @endif
                                        </div> --}}
                                        {{-- <div class="mb-3">
    <label class="form-label">Branch</label>

   
    <input type="text" class="form-control"
           value="@if(auth()->user()->role === 'admin')
                        ADMIN
                  @else
                        {{ strtoupper(optional($branches->firstWhere('id', auth()->user()->branch_id))->branch_name) }}
                  @endif"
           disabled>

    @if (auth()->user()->role === 'admin')
      
        <select name="branch_id" id="branch_id" class="form-control mt-2" required>
            <option value="">-- Select Branch --</option>
            @foreach ($branches as $branch)
                <option value="{{ $branch->id }}"
                    {{ old('branch_id', auth()->user()->branch_id ?? '') == $branch->id ? 'selected' : '' }}>
                    {{ $branch->branch_name }}
                </option>
            @endforeach
        </select>

    @else
      
        <input type="hidden" name="branch_id" value="{{ auth()->user()->branch_id }}">
    @endif
</div> --}}

                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="designation" class="form-label">Designation</label>
                                        <input type="text" name="designation" class="form-control" id="designation"
                                            value="{{ old('designation', $employee->designation) }}">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" name="name" class="form-control" id="name"
                                            value="{{ old('name', $employee->name) }}">
                                    </div>
                                    <div class="form-group mb-3">
    <label for="email" class="form-label">Email ID</label>
    <input type="email" name="email" class="form-control" id="email"
        value="{{ old('email', $employee->email) }}" placeholder="Enter employee email">
</div>
<div class="form-group mb-3">
    <label class="form-label">Password</label>
    <div style="position:relative;">
        <input type="password" id="password" name="password" class="form-control"
               value="{{ $employee->password_hint }}">
        <span onclick="togglePassword()" 
              style="position:absolute;right:10px;top:10px;cursor:pointer;">👁</span>
    </div>
</div>
                                    <div class="form-group mb-3">
                                        <label for="phone" class="form-label">Phone Number</label>
                                        <input type="text" name="phone" class="form-control" id="phone"
                                            value="{{ old('phone', $employee->phone) }}">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="address" class="form-label">Address</label>
                                        <input type="text" name="address" class="form-control" id="address"
                                            value="{{ old('address', $employee->address) }}">
                                    </div>
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Update
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div> <!-- card-body -->
                </div> <!-- card -->
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <!-- JQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!-- DataTable JS -->
    <script>
function togglePassword(){
    let input = document.getElementById('password');
    input.type = (input.type === "password") ? "text" : "password";
}
</script>
    <script src="{{ asset('/assets/js/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/vfs_fonts.js') }}"></script>
@endsection
