<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Offline Sale #{{ $order_id }}</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        /* Add any custom styles for your form here */
        .container { max-width: 900px; margin: 40px auto; padding: 20px; background-color: #fff; border-radius: 8px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        input[type="text"], input[type="number"], select, textarea { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; margin-bottom: 15px; }
        .form-section { margin-bottom: 30px; padding: 20px; border: 1px solid #eee; border-radius: 5px; background-color: #f9f9f9; }
        .form-section h3 { margin-top: 0; color: #333; }
        .item-row { display: flex; gap: 15px; align-items: flex-end; margin-bottom: 10px; }
        .item-row .input-group { flex: 1; }
        .item-row .remove-item { background-color: #dc3545; color: white; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer; }
        .add-item { background-color: #28a745; color: white; border: none; padding: 10px 15px; border-radius: 4px; cursor: pointer; margin-top: 15px; }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container">
        <h1 class="text-3xl font-bold text-center text-gray-800 mb-8">Edit Offline Sale #{{ $order_id }}</h1>

        @if (session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                {{ session('success') }}
            </div>
        @endif

        @if (session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                {{ session('error') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('offline_sales_update', ['orderId' => $order_id]) }}" method="POST">
            @csrf
            @method('PUT') <div class="form-section">
                <h3 class="text-xl font-semibold mb-4">Customer Details</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="customer_name">Customer Name:</label>
                        <input type="text" id="customer_name" name="customer_name" value="{{ old('customer_name', $customer['name'] ?? $name) }}">
                    </div>
                    <div>
                        <label for="customer_phone_number">Phone Number:</label>
                        <input type="text" id="customer_phone_number" name="customer_phone_number" value="{{ old('customer_phone_number', $customer['phone_number'] ?? $phone_number) }}">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                    <div>
                        <label for="customer_address_house_no">House No:</label>
                        <input type="text" id="customer_address_house_no" name="customer_address_house_no" value="{{ old('customer_address_house_no', $customer['address']['house_no'] ?? '') }}">
                    </div>
                    <div>
                        <label for="customer_address_road_name">Road Name:</label>
                        <input type="text" id="customer_address_road_name" name="customer_address_road_name" value="{{ old('customer_address_road_name', $customer['address']['road_name'] ?? '') }}">
                    </div>
                    <div>
                        <label for="customer_address_landmark">Landmark:</label>
                        <input type="text" id="customer_address_landmark" name="customer_address_landmark" value="{{ old('customer_address_landmark', $customer['address']['landmark'] ?? '') }}">
                    </div>
                    <div>
                        <label for="customer_address_district">District:</label>
                        <input type="text" id="customer_address_district" name="customer_address_district" value="{{ old('customer_address_district', $customer['address']['district'] ?? '') }}">
                    </div>
                    <div>
                        <label for="customer_address_state">State:</label>
                        <input type="text" id="customer_address_state" name="customer_address_state" value="{{ old('customer_address_state', $customer['address']['state'] ?? '') }}">
                    </div>
                    <div>
                        <label for="customer_address_pin">PIN:</label>
                        <input type="text" id="customer_address_pin" name="customer_address_pin" value="{{ old('customer_address_pin', $customer['address']['pin'] ?? '') }}">
                    </div>
                </div>
            </div>

            <div class="form-section">
                <h3 class="text-xl font-semibold mb-4">Sale Items</h3>
                <div id="sale-items-container">
                    @foreach ($items as $index => $item)
                        <div class="item-row mb-4 p-3 border rounded bg-white" data-item-index="{{ $index }}">
                            <div class="input-group">
                                <label for="sale_items_{{ $index }}_product_id">Product:</label>
                                <select name="sale_items[{{ $index }}][product_id]" id="sale_items_{{ $index }}_product_id"
                                    class="product-select" data-item-index="{{ $index }}">
                                    <option value="">Select Product</option>
                                    @foreach($allProducts as $product)
                                        <option value="{{ $product->product_id }}"
                                            @if($product->product_id == $item['product_id']) selected @endif>
                                            {{ $product->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="sale_items_{{ $index }}_variant_id">Variant:</label>
                                <select name="sale_items[{{ $index }}][variant_id]" id="sale_items_{{ $index }}_variant_id"
                                    class="variant-select">
                                    <option value="">Select Variant</option>
                                    {{-- Variants will be dynamically loaded here via JavaScript based on product selection --}}
                                    @if(isset($item['variant_id']))
                                        @foreach($allVariants->where('product_id', $item['product_id']) as $variant)
                                            <option value="{{ $variant->variant_id }}"
                                                @if($variant->variant_id == $item['variant_id']) selected @endif>
                                                {{ $variant->variant_name }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="sale_items_{{ $index }}_quantity">Quantity:</label>
                                <input type="number" id="sale_items_{{ $index }}_quantity" name="sale_items[{{ $index }}][quantity]" value="{{ old('sale_items.'.$index.'.quantity', $item['quantity']) }}" min="1">
                            </div>
                            <div class="input-group">
                                <label for="sale_items_{{ $index }}_sell_price">Unit Price (₹):</label>
                                <input type="number" id="sale_items_{{ $index }}_sell_price" name="sale_items[{{ $index }}][sell_price]" value="{{ old('sale_items.'.$index.'.sell_price', number_format($item['sell_price'], 2, '.', '')) }}" step="0.01">
                            </div>
                            <input type="hidden" name="sale_items[{{ $index }}][amount]" class="item-amount-hidden" value="{{ old('sale_items.'.$index.'.amount', number_format($item['amount'], 2, '.', '')) }}">
                            <button type="button" class="remove-item">Remove</button>
                        </div>
                    @endforeach
                </div>
                <button type="button" id="add-item" class="add-item">Add Item</button>
            </div>

            <div class="form-section">
                <h3 class="text-xl font-semibold mb-4">Financial Details</h3>
                <div>
                    <label for="total_amount">Subtotal:</label>
                    <input type="number" id="total_amount" name="total_amount" value="{{ old('total_amount', number_format($total_amount, 2, '.', '')) }}" step="0.01" readonly>
                </div>
                <div>
                    <label for="cash_wallet_deduction">Cash Wallet Deduction:</label>
                    <input type="number" id="cash_wallet_deduction" name="cash_wallet_deduction" value="{{ old('cash_wallet_deduction', number_format($cash_wallet_deduction, 2, '.', '')) }}" step="0.01">
                </div>
                <div>
                    <label for="shopping_wallet_deduction">Shopping Wallet Deduction:</label>
                    <input type="number" id="shopping_wallet_deduction" name="shopping_wallet_deduction" value="{{ old('shopping_wallet_deduction', number_format($shopping_wallet_deduction, 2, '.', '')) }}" step="0.01">
                </div>
                <div>
                    <label for="amount_payable">Amount Payable:</label>
                    <input type="number" id="amount_payable" name="amount_payable" value="{{ old('amount_payable', number_format($amount_payable, 2, '.', '')) }}" step="0.01" readonly>
                </div>
                <div>
                    <label for="payment_mode">Payment Mode:</label>
                    <input type="text" id="payment_mode" name="payment_mode" value="{{ old('payment_mode', $payment_mode) }}">
                </div>
            </div>

            <div class="text-center">
                <button type="submit" class="print-button bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">Update Invoice</button>
                <a href="{{ route('offline_sales_edit', ['orderId' => $order_id]) }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded ml-4">Cancel</a>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const saleItemsContainer = document.getElementById('sale-items-container');
            const addItemButton = document.getElementById('add-item');
            let itemIndex = {{ count($items) }}; // Start new items from this index

            const allProducts = @json($allProducts->keyBy('product_id'));
            const allVariants = @json($allVariants->groupBy('product_id'));

            // Function to update totals
            function updateTotals() {
                let totalAmount = 0;
                saleItemsContainer.querySelectorAll('.item-row').forEach(row => {
                    const quantity = parseFloat(row.querySelector('input[name$="[quantity]"]').value) || 0;
                    const sellPrice = parseFloat(row.querySelector('input[name$="[sell_price]"]').value) || 0;
                    const itemAmount = quantity * sellPrice;
                    row.querySelector('.item-amount-hidden').value = itemAmount.toFixed(2);
                    totalAmount += itemAmount;
                });

                document.getElementById('total_amount').value = totalAmount.toFixed(2);

                const cashWalletDeduction = parseFloat(document.getElementById('cash_wallet_deduction').value) || 0;
                const shoppingWalletDeduction = parseFloat(document.getElementById('shopping_wallet_deduction').value) || 0;

                const amountPayable = totalAmount - cashWalletDeduction - shoppingWalletDeduction;
                document.getElementById('amount_payable').value = Math.max(0, amountPayable).toFixed(2);
            }

            // Function to populate variants based on selected product
            function populateVariants(productSelect) {
                const itemRow = productSelect.closest('.item-row');
                const variantSelect = itemRow.querySelector('.variant-select');
                const productId = productSelect.value;

                variantSelect.innerHTML = '<option value="">Select Variant</option>'; // Clear existing options

                if (productId && allVariants[productId]) {
                    allVariants[productId].forEach(variant => {
                        const option = document.createElement('option');
                        option.value = variant.variant_id;
                        option.textContent = variant.variant_name;
                        variantSelect.appendChild(option);
                    });
                }
            }

            // Event listener for product select change
            saleItemsContainer.addEventListener('change', function(event) {
                if (event.target.classList.contains('product-select')) {
                    populateVariants(event.target);
                    updateTotals(); // Recalculate if product selection might imply price change (not directly, but good practice)
                } else if (event.target.matches('input[name$="[quantity]"]') || event.target.matches('input[name$="[sell_price]"]')) {
                    updateTotals();
                } else if (event.target.id === 'cash_wallet_deduction' || event.target.id === 'shopping_wallet_deduction') {
                    updateTotals();
                }
            });

            // Event listener for remove item button
            saleItemsContainer.addEventListener('click', function(event) {
                if (event.target.classList.contains('remove-item')) {
                    event.target.closest('.item-row').remove();
                    updateTotals();
                }
            });

            // Event listener for add item button
            addItemButton.addEventListener('click', function() {
                const newRow = document.createElement('div');
                newRow.classList.add('item-row', 'mb-4', 'p-3', 'border', 'rounded', 'bg-white');
                newRow.dataset.itemIndex = itemIndex;
                newRow.innerHTML = `
                    <div class="input-group">
                        <label for="sale_items_${itemIndex}_product_id">Product:</label>
                        <select name="sale_items[${itemIndex}][product_id]" id="sale_items_${itemIndex}_product_id"
                            class="product-select" data-item-index="${itemIndex}">
                            <option value="">Select Product</option>
                            ${Object.values(allProducts).map(product => `<option value="${product.product_id}">${product.title}</option>`).join('')}
                        </select>
                    </div>
                    <div class="input-group">
                        <label for="sale_items_${itemIndex}_variant_id">Variant:</label>
                        <select name="sale_items[${itemIndex}][variant_id]" id="sale_items_${itemIndex}_variant_id"
                            class="variant-select">
                            <option value="">Select Variant</option>
                        </select>
                    </div>
                    <div class="input-group">
                        <label for="sale_items_${itemIndex}_quantity">Quantity:</label>
                        <input type="number" id="sale_items_${itemIndex}_quantity" name="sale_items[${itemIndex}][quantity]" value="1" min="1">
                    </div>
                    <div class="input-group">
                        <label for="sale_items_${itemIndex}_sell_price">Unit Price (₹):</label>
                        <input type="number" id="sale_items_${itemIndex}_sell_price" name="sale_items[${itemIndex}][sell_price]" value="0.00" step="0.01">
                    </div>
                    <input type="hidden" name="sale_items[${itemIndex}][amount]" class="item-amount-hidden" value="0.00">
                    <button type="button" class="remove-item">Remove</button>
                `;
                saleItemsContainer.appendChild(newRow);
                itemIndex++;
                updateTotals(); // Update totals after adding a new row (might have default values)
            });

            // Initial population of variants and total calculation for existing items
            saleItemsContainer.querySelectorAll('.product-select').forEach(populateVariants);
            updateTotals();
        });
    </script>
</body>
</html>