@extends('admin.layouts')
@section('title', 'Banner')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">
 <!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-oBqDVmMz4fnFO9t5a6P6A6O6A0p3U7v38wzA1N39N7Jt6jvNIi2B2i+1DkF1Vr" crossorigin="anonymous"></script>

@endsection
@section('content')



<div class="container-fluid page-wrapper category-container">

   <div class="row">
        <div class="d-flex align-items-center">
            <h3 class="page-top-heading">Edit Shopping Wallet</h3>
        </div>
    </div>
 
    <div class="row d-flex justify-content-center mt-4">
        <div class="col-lg-6">
            <div class="card ILY-form-card">
                <div class="card-header">
                    <h5 class="card-title">Add Banner</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('shopwallet_update', $user->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf 
                        <div class="row">
                            <div class="col-lg-12">
                                <!-- Type Dropdown (Credit/Debit) -->
                                <div class="form-group mb-3">
                                    <label for="type" class="form-label">Type</label>
                                    <select name="type" id="type" class="form-control" required>
                                        <option value="Credit">Credit</option>
                                        <option value="Debit">Debit</option>
                                    </select>
                                </div>
                                
                                <!-- Amount Input -->
                                <div class="form-group mb-3">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="number" name="amount" class="form-control" id="amount" placeholder="Enter Amount" required min="1">
                                </div>
                    
                                <!-- Hidden Old Wallet Value -->
                                <input type="hidden" name="old_cash_wallet" value="{{ $user->incomeWallet->shopping_wallet ?? '0.00' }}">
                    
                                <!-- Remark Input -->
                                <div class="form-group mb-3">
                                    <label for="remark" class="form-label">Remark</label>
                                    <input type="text" name="remark" class="form-control" id="remark" placeholder="Enter Remark" required>
                                </div>
                    
                                <!-- Submit Button -->
                                <div class="button-container mt-4">
                                    <button type="submit" class="btn btn-primary submit-btn">
                                        <i class="fa-regular fa-circle-check me-2"></i> Submit
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                    
                    
                </div>
            </div>
        </div>
    </div>

    <!-- Table Row -->
    <div class="row mt-5">
        <div class="col-lg-12">
           <div class="mb-3">
               <h6 class="table-heading">History</h6>
           </div>
            <div class="card datatable-card">
                <div class="card-body">
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>DATE</th>
                                <th>TYPE</th>
                                <th>AMOUNT</th>
                                <th>REMARK</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($datatable as $table)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $table->created_at->format('d-m-Y') }}</td>
                                    <td>{{ $table->type }}</td>
                                    <td>{{ number_format($table->amount, 2) }}</td>
                                    <td>{{ $table->remark }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-danger">No Data Available</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                    

                </div>
            </div>
        </div>
    </div>
    <!-- Table Row Ends -->

   
    
</div>
@endsection
@section('footer')

<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>

@endsection