@extends('admin.layouts')
@section('title', 'Add Category')
@section('header')
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
@endsection

@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Edit User</h3>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Edit User</h5>
                    </div>
                    <div class="card-body">
                       

                        <form action="{{ route('edit_update', $user->id) }}" method="POST" autocomplete="off">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Name</label>
                                    <input type="text" class="form-control" name="name" value="{{ old('name', $user->name) }}" >
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" value="{{ old('email', $user->email) }}" >
                                </div>
                                 <div class="col-lg-6 mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="text" class="form-control" name="password"  value="{{ old('password', $user->password)}}" >
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Phone Number</label>
                                    <input type="text" class="form-control" name="phone" value="{{ old('phone_number', $user->phone_number) }}" >
                                </div>
                             
                                <div class="col-lg-6 mb-3">
    <label class="form-label">Payment Mode</label>
    <input type="text" class="form-control" name="payment_mode" placeholder="Enter Payment Mode"
        value="{{ old('payment_mode') }}">
</div>

                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Membership</label>
                                    <input type="text" class="form-control" id="plan_amount" value="{{ old('membership', $user->membership) }}" readonly>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Plan Name</label>
                                    <input type="text" class="form-control" name="plan_name" id="plan_name"
                                        value="{{ old('plan_name', $membershipTitle) }}" readonly>
                                    
                                </div>
                              
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label class="form-label">Joining Date</label>
                                        <input type="text" class="form-control" name="joining_date"
                                            value="{{ old('created_at', $user->created_at) }}" readonly>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label class="form-label">Membership Plan (Optional)</label>
                                        <select class="form-control" name="membership_id">
                                            <option value="">Select Membership</option>
                                            @foreach ($memberships as $membership)
                                                <option value="{{ $membership->id }}" 
                                                    {{ old('membership_id', $user->membership) == $membership->id ? 'selected' : '' }}>
                                                    {{ $membership->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12 text-center">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                                           </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->
    </div>
    <!-- end container fluid -->
@endsection


@section('footer')


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let selectedMembership = "{{ old('membership_id', $user->membership_id) }}";

            if (selectedMembership) {
                let membershipSelect = document.querySelector('select[name="membership_id"]');
                let options = membershipSelect.options;

                for (let i = 0; i < options.length; i++) {
                    if (options[i].value === selectedMembership) {
                        options[i].selected = true;
                        break;
                    }
                }
            }
        });
    </script>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


@endsection
