@extends('admin.layouts')
@section('title', 'employee list')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
    <style>
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        td.user-details {
            max-width: 250px;
            /* Adjust width as needed */
            white-space: normal !important;
            /* Allow line wrapping */
            word-wrap: break-word;
        }

        .user-details {
            max-width: 200px;
            /* Limit width */
            white-space: normal !important;
            /* Allow text to wrap */
            word-break: break-word;
            /* Break long text like email */
            font-size: 13px;
            /* Make it slightly smaller */
            line-height: 1.4;
            /* Reduce spacing */
        }
    </style>
@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Employee List</h3>
            </div>
        </div>






        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">


                        <div class="table-responsive">

                            <table id="data-table" class="table nowrap align-middle" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>DATE</th>
                                        <th>EMPLOYEE NAME</th>
                                        <th>EMAIL</th>
                                        <th>PHONE</th>
                                        <th>BRANCH</th>
                                        <th>DESIGNATION</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($employees as $employee)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $employee->created_at->format('Y-m-d') }}</td>
                                            <td>{{ $employee->name }}</td>
                                            <td>{{ $employee->email }}</td>
                                            <td>{{ $employee->phone }}</td>
                                            <td>{{ $employee->designation }}</td>
                                            <td>{{ $employee->role }}</td>
                                            <td>
                                                <a href="{{ route('view_employee', ['id' => $employee->id]) }}"
                                                    class="text-primary" title="View Employee">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <button class="btn btn-danger btn-sm" onclick="confirmDelete({{ $employee->id }})" title="Delete Employee">
        <i class="fas fa-trash"></i>
    </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->


<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="deleteForm" method="POST">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Are you sure you want to delete this employee?
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-danger">Yes, Delete</button>
        </div>
      </div>
    </form>
  </div>
</div>


    </div>
    <!-- end container fluid -->




@endsection
@section('footer')

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    {{-- <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script> --}}
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

<script>
function confirmDelete(employeeId) {
    const form = document.getElementById('deleteForm');
    form.action = '/employees/delete/' + employeeId; // your delete route
    var myModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    myModal.show();
}
</script>


@endsection
