<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employee Login | Adbazzar</title>
    <link rel="icon" href="{{ asset('/assets') }}/images/favicon.icon" type="image/x-icon">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/bootstrap/5.3.2/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/fontawesome.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/brands.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/regular.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/solid.css">
    <!-- Page CSS -->
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/style.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/authentication.css">
</head>

<body>
    <div class="page-content overflow-hidden min-vh-100 login-container">
        <div class="row g-0 vh-100">
            <div class="col-xl-5 col-lg-5 col-md-6 col-sm-6 rightside-widget-col">
                <div class="p-lg-5 p-4 h-100 logo-widget" style="background: url('{{ asset('/assets') }}/images/adbazzar-logo.png.svg'); background-size: cover;">
                    <div class="d-flex justify-content-center align-items-center h-100">
                        <img src="{{ asset('/assets') }}/images/login-frame.svg" style="height:400px;" alt="login frame">
                    </div>
                </div>
            </div>

            <div class="col-xl-7 col-lg-7 col-md-6 col-sm-6 d-flex justify-content-center align-items-center">
                <div class="py-3 px-lg-5 px-md-4 px-sm-4 px-4 form-container row">
                    <div class="d-flex justify-content-center mb-1">
                        <img src="{{ asset('/assets') }}/images/logo-horizontal.svg" class="d-none widget-logo" alt="logo-horizontal">
                    </div>
                    <div class="text-start">
                        <h3 class="login-heading">Login</h3>
                        <p class="py-2 login-slogan">Please fill your information below</p>
                    </div>

                    <form action="{{ route('employee_login_post') }}" method="POST" class="row g-3 needs-validation" autocomplete="off">
                        @csrf

                        <!-- Email -->
                        <div class="input-group mb-4">
                            <span class="input-group-text">
                                <img src="{{ asset('/assets') }}/images/icons/envelope.svg" alt="Email Icon">
                            </span>
                            <input type="email" name="email" class="form-control" placeholder="E-mail" required>
                        </div>

                        <!-- Password -->
                        <div class="input-group mb-3 position-relative">
                            <span class="input-group-text">
                                <img src="{{ asset('/assets') }}/images/icons/lock.svg" alt="Lock Icon">
                            </span>
                            <input type="password" name="password" id="password" class="form-control" placeholder="Password" autocomplete="new-password" required>
                            <span class="toggle-password position-absolute" style="right: 20px; top: 50%; transform: translateY(-50%); cursor: pointer;">
                                <i class="fa-solid fa-eye-slash" id="togglepassword"></i>
                            </span>
                        </div>

                        <div class="d-flex justify-content-end align-items-center">
                            <a href="{{ route('forgot_password') }}" class="forgot-pwd">Forgot Password?</a>
                        </div>

                        <!-- Login Button -->
                        <div class="login-btn-container mt-3">
                            <button type="submit" class="btn btn-success login-btn w-100">Login</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Toasts -->
    @if (session('successmessage'))
        <div class="toast bg-success align-items-center border-0 show" style="position: fixed; top: 150px; right: 20px; z-index: 1050; border-radius: 8px;">
            <div class="toast-body d-flex text-white align-items-center">
                <i class="fa-regular fa-circle-check me-2"></i>
                <div>{{ session('successmessage') }}</div>
                <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    @endif

    @if ($errors->any())
        <div class="toast bg-danger align-items-center border-0 show" style="position: fixed; top: 80px; right: 20px; z-index: 1050; border-radius: 8px;">
            <div class="toast-body d-flex text-white align-items-center">
                <i class="fa-solid fa-circle-exclamation me-2"></i>
                <div>
                    @foreach ($errors->all() as $error)
                        <div>{{ $error }}</div>
                    @endforeach
                </div>
                <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    @endif

    <!-- Scripts -->
    <script src="{{ asset('/assets') }}/js/bootstrap/5.3.2/bootstrap.min.js"></script>
    <script src="{{ asset('/assets') }}/js/authentication.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        // Toggle password visibility
        document.addEventListener('DOMContentLoaded', function () {
            const passwordField = document.getElementById('password');
            const toggleIcon = document.getElementById('togglepassword');

            toggleIcon.addEventListener('click', function () {
                const isPassword = passwordField.type === 'password';
                passwordField.type = isPassword ? 'text' : 'password';
                toggleIcon.classList.toggle('fa-eye');
                toggleIcon.classList.toggle('fa-eye-slash');
            });
        });
    </script>
</body>

</html>
