@extends('admin.layouts')
@section('title', 'GSTR-1 (Sales)')
@section('header')
    <!-- DataTable CSS -->
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/responsive.bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/css/datatable/buttons.dataTables.min.css') }}">
    <!-- Page CSS -->
    <link rel="stylesheet" href="{{ asset('/assets/css/formILY.css') }}">
@endsection
@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">GSTR-1 (Sales)</h3>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
            </div>
            <div class="row mt-3">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="fromDate">From Date:</label>
                        <input type="date" class="form-control" id="fromDate">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="toDate">To Date:</label>
                        <input type="date" class="form-control" id="toDate">
                    </div>
                </div>
                <div class="col-md-3 d-flex align-items-end justify-content-end">
                    <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                    <button class="btn btn-secondary" id="resetBtn">Reset</button>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12">
                    <div id="totalAmountDisplay" class="total-amount-display">
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card datatable-card">
                        <div class="card-body">
                            {{-- <table id="salesTable" class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Customer Name</th>
                                        <th>Invoice Number</th>
                                        <th>Invoice Date</th>
                                        <th>Invoice Value</th>
                                        <th>Total Tax (%)</th>
                                        <th>Taxable Value</th>
                                        <th>CGST</th>
                                        <th>SGST</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($sales as $sale)
                                        @php
                                            $customer = is_string($sale->customer_details)
                                                ? json_decode($sale->customer_details, true) ?? []
                                                : $sale->customer_details ?? [];
                                            $totalCgst = 0;
                                            $totalSgst = 0;
                                            $totalGstPercent = 0;
                                            $totalTaxable = 0;
                                            foreach ($sale->sale_items as $item) {
                                                $productId = $item['item_identifier'] ?? null;
                                                $product = \App\Models\Product::where(
                                                    'product_id',
                                                    $productId,
                                                )->first();
                                                $sellPrice = $item['sell_price'] ?? 0;
                                                $quantity = $item['quantity'] ?? 0;
                                                $taxableValue = $sellPrice * $quantity;
                                                $totalTaxable += $taxableValue;
                                                $cgst = $product->cgst ?? 0;
                                                $sgst = $product->sgst ?? 0;
                                                $totalGstPercent += $cgst + $sgst;
                                                $totalCgst += $cgst;
                                                $totalSgst += $sgst;
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $customer['name'] ?? 'N/A' }}</td>
                                            <td>{{ $sale->order_id ?? '-' }}</td>
                                            <td>{{ $sale->created_at ? $sale->created_at->format('d-m-Y') : '-' }}</td>
                                            <td>₹{{ number_format($sale->amount_payable ?? 0, 2) }}</td>
                                            <td>{{ $totalGstPercent }}%</td>
                                            <td>₹{{ number_format($totalTaxable, 2) }}</td>
                                            <td>₹{{ number_format($totalCgst, 2) }}</td>
                                            <td>₹{{ number_format($totalSgst, 2) }}</td>
                                            <td>
                                                <a href="{{ url('admin/invoice_a4/' . $sale->order_id) }}" target="_blank"
                                                    class="btn btn-info btn-sm">View Invoice</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                </tbody>
                            </table> --}}
                            {{-- ///////////////////////////// --}}
                          {{-- <table id="salesTable" class="table table-bordered">
    <thead>
        <tr>
            <th>#</th>
            <th>Customer Name</th>
            <th>Invoice Number</th>
            <th>Invoice Date</th>
            <th>Invoice Value</th>
            <th>Taxable Value</th>
            <th>CGST</th>
            <th>SGST</th>
            <th>Total Tax</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($sales as $sale)
            @php
                $customer = is_array($sale->customer_details)
                    ? $sale->customer_details
                    : (json_decode($sale->customer_details, true) ?? []);
            @endphp
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $customer['name'] ?? 'N/A' }}</td>
                <td>{{ $sale->order_id ?? '-' }}</td>
                <td>{{ $sale->created_at?->format('d-m-Y') ?? '-' }}</td>
                <td>₹{{ number_format($sale->amount_payable ?? 0, 2) }}</td>
                <td>
    ₹{{ number_format(($sale->amount_payable ?? 0) - ($sale->cgst ?? 0) - ($sale->sgst ?? 0), 2) }}
</td>
                <td>₹{{ number_format($sale->tax_value ?? 0, 2) }}</td>
                <td>₹{{ number_format($sale->cgst ?? 0, 2) }}</td>
                <td>₹{{ number_format($sale->sgst ?? 0, 2) }}</td>
                <td>
                    <a href="{{ url('admin/invoice_a4/' . $sale->order_id) }}"
                       target="_blank"
                       class="btn btn-info btn-sm">
                        View Invoice
                    </a>
                </td>
            </tr>
        @endforeach
    </tbody>
</table> --}}
{{-- ///////////////////////////// --}}
<table id="salesTable" class="table table-bordered">
    <thead>
        <tr class="text-center">
            <th>#</th>
            <th>Invoice Number</th>
            <th>Invoice Date</th>
            <th>Invoice Value</th>
            <th>Total Tax(%)</th>
            <th>Taxable Value</th>
            <th>CGST</th>
            <th>SGST</th>
            <th>Total Tax</th>
              <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($sales as $sale)
            @php
                $invoice   = $sale->amount_payable ?? 0; // Invoice Value
                $cgst      = $sale->cgst ?? 0;
                $sgst      = $sale->sgst ?? 0;
                $taxable   = $invoice - ($cgst + $sgst);   // Taxable Value like Screenshot
                $totalTax  = $cgst + $sgst;                // Only CGST + SGST
                $taxPercent = $taxable > 0 ? round(($totalTax / $taxable) * 100) : 0;
            @endphp
            <tr class="text-center">
                <td>{{ $loop->iteration }}</td>
                <td>{{ $sale->order_id }}</td>
                <td>{{ $sale->created_at?->format('d-m-Y') }}</td>
                <td>₹{{ number_format($taxable,2) }}</td> {{-- Taxable Value like Screenshot --}}

                <td>{{ $taxPercent }}%</td> {{-- Tally style Total Tax % --}}
                <td>₹{{ number_format($invoice,2) }}</td>

                <td>₹{{ number_format($cgst,2) }}</td>
                <td>₹{{ number_format($sgst,2) }}</td>
                <td>₹{{ number_format($totalTax,2) }}</td>
                 <td>
                    <a href="{{ url('admin/invoice_a4/' . $sale->order_id) }}"
                       target="_blank"
                       class="btn btn-info btn-sm">
                        View Invoice
                    </a>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('/assets/js/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('/assets/js/datatable/vfs_fonts.js') }}"></script>
<script>
$(document).ready(function () {
    var table = $('#salesTable').DataTable({
        responsive: true,
        dom: 'frtip',
        pageLength: 10
    });
    new $.fn.dataTable.Buttons(table, {
        buttons: [
            { extend: 'excel', className: 'buttons-excel' },
            { extend: 'pdf', className: 'buttons-pdf' },
            { extend: 'print', className: 'buttons-print' }
        ]
    });
    table.buttons().container().appendTo('#salesTable_wrapper .col-md-6:eq(0)').hide();
    $('.excel-btn').on('click', function () {
        table.button('.buttons-excel').trigger();
    });
    $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
        let fromDate = $('#fromDate').val();
        let toDate = $('#toDate').val();
        let dateText = data[3];
        if (!fromDate && !toDate) return true;
        let parts = dateText.split("-");
        let rowDate = new Date(parts[2], parts[1] - 1, parts[0]);
        if (fromDate && rowDate < new Date(fromDate)) return false;
        if (toDate && rowDate > new Date(toDate)) return false;
        return true;
    });
    $('#filterBtn').click(() => table.draw());
    $('#resetBtn').click(() => { $('#fromDate,#toDate').val(""); table.draw(); });
    function updateTotals() {
        let totalAmount = 0;
        table.rows({ search: 'applied' }).every(function () {
            let raw = this.data()[4].replace('₹', '').replace(/,/g, '').trim();
            totalAmount += parseFloat(raw);
        });
        $('#totalAmountDisplay').html(
            `<strong>Total Invoice Value:</strong> ₹${totalAmount.toLocaleString('en-IN',{minimumFractionDigits:2})}`
        );
    }
    table.on('draw.dt', updateTotals);
    updateTotals();
});
</script>
@endsection
