
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice #{{ $invoice->order_random_id }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .invoice-container {
            width: 100%;
            max-width: 850px;
            margin: 40px auto;
            background: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            box-sizing: border-box;
        }

        .invoice-header {
            background-color: #4CAF50;
            /* Primary Green */
            color: #ffffff;
            padding: 30px 40px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .invoice-header h1 {
            margin: 0;
            font-size: 32px;
            font-weight: 700;
        }

        .invoice-header .company-info {
            text-align: right;
            font-size: 14px;
        }

        .invoice-header .company-info strong {
            font-size: 18px;
            display: block;
            margin-bottom: 5px;
        }

        .invoice-body {
            padding: 40px;
        }

        .invoice-details,
        .billing-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            line-height: 1.8;
            font-size: 14px;
        }

        .invoice-details div,
        .billing-info div {
            flex: 1;
            padding-right: 20px;
        }

        .invoice-details div:last-child,
        .billing-info div:last-child {
            padding-right: 0;
            text-align: right;
        }

        .invoice-details strong,
        .billing-info strong {
            display: block;
            margin-bottom: 5px;
            font-size: 16px;
            color: #333;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            font-size: 14px;
        }

        .invoice-table th,
        .invoice-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        .invoice-table th {
            background-color: #f8f9fa;
            color: #555;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 13px;
        }

        .invoice-table tbody tr:last-child td {
            border-bottom: none;
        }

        .invoice-table .item-description {
            font-weight: 600;
            color: #333;
        }

        .invoice-table .item-variant {
            font-size: 12px;
            color: #777;
            display: block;
            margin-top: 2px;
        }

        .invoice-summary {
            display: flex;
            justify-content: flex-end;
            margin-top: 20px;
        }

        .invoice-summary-table {
            width: 100%;
            max-width: 300px;
            border-collapse: collapse;
            font-size: 14px;
        }

        .invoice-summary-table td {
            padding: 10px 15px;
            border-bottom: 1px solid #e0e0e0;
        }

        .invoice-summary-table td:first-child {
            font-weight: 600;
            color: #555;
        }

        .invoice-summary-table tr:last-child td {
            border-bottom: none;
        }

        .invoice-summary-table .total-amount td {
            background-color: #e6ffe6;
            /* Light green for total */
            font-size: 16px;
            font-weight: 700;
            color: #007b00;
        }

        .invoice-footer {
            background-color: #f8f9fa;
            padding: 20px 40px;
            text-align: center;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #e0e0e0;
        }

        /* Print Specific Styles */
        @media print {
            body {
                background-color: #fff;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
            }

            .invoice-container {
                box-shadow: none;
                border: none;
                margin: 0;
                border-radius: 0;
            }

            .invoice-header {
                background-color: #4CAF50 !important;
                color: #ffffff !important;
            }

            .invoice-table th {
                background-color: #f8f9fa !important;
            }

            .invoice-summary-table .total-amount td {
                background-color: #e6ffe6 !important;
            }

            .no-print {
                display: none;
            }
        }

        .print-button-container {
            text-align: center;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        .print-button {
            padding: 10px 25px;
            font-size: 16px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .print-button:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>
    <div class="invoice-container">
        <div class="invoice-header">
            <h1>Invoice</h1>
            <div class="company-info">
                <img src="{{ asset('/assets') }}/images/adbazzar-logo.png.svg" alt="AdBazzar"
                    style="height: 60px; margin-bottom: 10px;">
                <strong>AdBazzar</strong>
                Chennai, India<br>
                +91 8531345678<br>
                adbazzar@gmail.com
            </div>
        </div>

        <div class="invoice-body">
            <div class="invoice-details">
                <div>
                    <strong>Invoice ID:</strong> #{{ $invoice->order_random_id }}<br>
                    <strong>Invoice Date:</strong> {{ \Carbon\Carbon::parse($invoice->order_date)->format('M d, Y') }}<br>
                   </div>
                <div>
                    <strong>BILL TO</strong>
                    {{ $invoice->user->name ?? 'N/A' }}<br>
                    {{ $invoice->delivery_address }}<br>
                    Phone: {{ $invoice->user->phone_number ?? 'N/A' }}
                </div>
            </div>

         <table class="invoice-table">
    <thead>
        <tr>
            <th>Description</th>
            <th>Quantity</th>
            <th>Unit Price</th>
            <th>Subtotal</th>
        </tr>
    </thead>
    <tbody>
        @php
            // Decode all necessary fields
            $price_details = is_string($invoice->price_details)
                ? json_decode($invoice->price_details, true)
                : $invoice->price_details;

            $quantities = is_string($invoice->quantity)
                ? json_decode($invoice->quantity, true)
                : $invoice->quantity;

            $product_names = is_string($invoice->product_details_name)
                ? json_decode($invoice->product_details_name, true)
                : $invoice->product_details_name;

            $variant_ids = is_string($invoice->variant_id)
                ? json_decode($invoice->variant_id, true)
                : $invoice->variant_id;

            // Decode imei_serial_numbers
            $imei_serial_numbers = is_string($invoice->imei_serial_numbers)
                ? json_decode($invoice->imei_serial_numbers, true)
                : $invoice->imei_serial_numbers;

            // Ensure all decoded variables are arrays, even if null
            $price_details = is_array($price_details) ? $price_details : [];
            $quantities = is_array($quantities) ? $quantities : [];
            $product_names = is_array($product_names) ? $product_names : [];
            $variant_ids = is_array($variant_ids) ? $variant_ids : [];
            $imei_serial_numbers = is_array($imei_serial_numbers) ? $imei_serial_numbers : [];
        @endphp

        @foreach ($product_names as $key => $product_name)
            <tr>
                <td>
                    <span class="item-description">{{ $product_name }}</span>
                    @if (isset($variant_ids[$key]) && $variant_ids[$key] != 'N/A' && $variant_ids[$key] != '')
                        <br><small class="item-variant text-muted">Variant: {{ $variant_ids[$key] }}</small>
                    @endif

                    {{-- Display IMEI/Serial Number --}}
                    @if (isset($imei_serial_numbers[$key]) && $imei_serial_numbers[$key] != '')
                        <br><small class="item-imei-serial text-muted">IMEI/Serial: {{ $imei_serial_numbers[$key] }}</small>
                    @endif

                    @if (isset($invoice->instruction))
                        <br><small class="item-instructions text-muted">Instructions: {{ $invoice->instruction }}</small>
                    @endif
                </td>
                <td>{{ $quantities[$key] ?? 1 }}</td>
                <td>₹{{ number_format(floatval($price_details[$key] ?? 0), 2, '.', ',') }}</td>
                <td>₹{{ number_format(floatval($price_details[$key] ?? 0) * ($quantities[$key] ?? 1), 2, '.', ',') }}
                </td>
            </tr>
        @endforeach
    </tbody>
</table>

            <div class="invoice-summary">
    <table class="invoice-summary-table">
        @php
            $is_gst = \App\Models\User::where('role', 'admin')->where('is_gst', 1)->exists();
            $gst_rate = 18; 
            $subtotal_items = 0;
            if (isset($price_details) && isset($quantities)) {
                foreach ($price_details as $key => $price) {
                    $subtotal_items += floatval($price ?? 0) * ($quantities[$key] ?? 1);
                }
            }
            $amount_payable = $invoice->amount;

            $beforeGstValue = 0;
            $cgst = 0;
            $sgst = 0;
            $totalGst = 0;
            $finalTotalAmount = $amount_payable; 

            if ($is_gst && $amount_payable > 0 && $gst_rate > 0) {
                $beforeGstValue = round($amount_payable / (1 + $gst_rate / 100), 2);
                $totalGst = round($amount_payable - $beforeGstValue, 2);
                $cgst = round($totalGst / 2, 2);
                $sgst = round($totalGst / 2, 2);
            } else {
                $beforeGstValue = $amount_payable;
                $totalGst = 0;
            }
        @endphp

        <tr>
            <td>Subtotal (Items):</td>
            <td>₹{{ number_format($subtotal_items, 2, '.', ',') }}</td>
        </tr>
        <tr>
            <td>Cash Wallet Used:</td>
            <td>₹{{ number_format($invoice->cash_wallet ?? 0, 2, '.', ',') }}</td>
        </tr>
        <tr>
            <td>Shopping Wallet Used:</td>
            <td>₹{{ number_format($invoice->shopp_wallet ?? 0, 2, '.', ',') }}</td>
        </tr>
        <tr>
            <td>Delivery Fee:</td>
            <td>₹{{ number_format($invoice->delivery_fee ?? 0, 2, '.', ',') }}</td>
        </tr>
        <tr class="total-amount">
            <td>Amount Payable:</td>
            <td>₹{{ number_format($amount_payable, 2, '.', ',') }}</td>
        </tr>

        @if ($is_gst)
            <tr>
                <td>Before GST Value:</td>
                <td>₹{{ number_format($beforeGstValue, 2, '.', ',') }}</td>
            </tr>
            <tr>
                <td>SGST ({{ $gst_rate / 2 }}%):</td>
                <td>+₹{{ number_format($sgst, 2, '.', ',') }}</td>
            </tr>
            <tr>
                <td>CGST ({{ $gst_rate / 2 }}%):</td>
                <td>+₹{{ number_format($cgst, 2, '.', ',') }}</td>
            </tr>
            <tr class="total-amount">
                <td>Total (incl. GST):</td>
                <td>₹{{ number_format($finalTotalAmount, 2, '.', ',') }}</td>
            </tr>
        @endif
    </table>
</div>

        </div>

        <div class="invoice-footer">
            <p>Thank you for your business! If you have any questions about this invoice, please contact AdBazzar.</p>
            <p>
                <strong>Order ID:</strong> {{ $invoice->order_random_id }} |
                <strong>Shiprocket Order ID:</strong> {{ $invoice->shiprocket_order_id ?? 'N/A' }} |
                <strong>Shipment ID:</strong> {{ $invoice->shipment_id ?? 'N/A' }} |
                <strong>ShipRocket Status:</strong> {{ $invoice->ship_rocket_status ?? 'N/A' }}
            </p>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

    <script>
        function downloadInvoice() {
            const element = document.querySelector('.invoice-container');

            const options = {
                margin: 10,
                filename: 'invoice_{{ $invoice->order_random_id }}.pdf',
                image: {
                    type: 'jpeg',
                    quality: 0.98
                },
                html2canvas: {
                    scale: 2,
                    useCORS: true
                },
                jsPDF: {
                    unit: 'mm',
                    format: 'a4',
                    orientation: 'portrait'
                }
            };

            html2pdf().from(element).set(options).save();
        }

        // Automatically trigger download on page load
        window.onload = function() {
            downloadInvoice();
            // setTimeout(() => {
            //     window.close(); // Close window after 2 seconds (optional)
            // }, 2000);
        };
    </script>
</body>

</html>