<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thermal Print #{{ $myPurchase->order_id }}</title>
    <style>
        body {
            font-family: 'Consolas', 'Courier New', monospace; /* Monospace font for thermal printers */
            font-size: 12px; /* Smaller font for thermal */
            width: 80mm; /* Standard 3 inch (76-80mm) thermal paper width */
            margin: 0;
            padding: 5mm; /* Small padding */
        }
        .receipt-container {
            width: 100%;
            margin: 0 auto;
        }
        .header, .footer {
            text-align: center;
            margin-bottom: 10px;
        }
        .header h3, .header p {
            margin: 0;
            line-height: 1.2;
        }
        .details, .summary {
            margin-bottom: 10px;
        }
        .item-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .item-table th, .item-table td {
            border-bottom: 1px dashed #ccc; /* Dashed line for separation */
            padding: 3px 0;
            text-align: left;
        }
        .item-table th:nth-child(1), .item-table td:nth-child(1) { width: 5%; } /* Qty */
        .item-table th:nth-child(2), .item-table td:nth-child(2) { width: 55%; } /* Item Name */
        .item-table th:nth-child(3), .item-table td:nth-child(3) { width: 40%; text-align: right; } /* Price */

        .item-table .qty-col { text-align: center; }
        .item-table .price-col { text-align: right; }

        .line {
            border-bottom: 1px dashed #000;
            margin: 5px 0;
        }
        .text-right {
            text-align: right;
        }
        .total-row {
            font-weight: bold;
            font-size: 14px;
        }
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }
        }
    </style>
</head>

<body>
    <div class="receipt-container">
        <div class="header">
            <div>
            <h2>{{ $branchInfo['name'] }}</h2>
            <div class="company-info">
                {{ $branchInfo['address'] }}<br>
                Phone: {{ $branchInfo['phone'] }}<br>
                Email: {{ $branchInfo['email'] }}
            </div>
        </div>
        <div class="text-end mt-3 mt-lg-0">
            <h4 class="text-uppercase">Purchase Invoice</h4>
            {{-- <strong>Invoice No:</strong> {{ $myPurchase->invoice_number }}<br> --}}
            <strong>Date:</strong> {{ \Carbon\Carbon::parse($myPurchase->purchase_date)->format('d-M-Y H:i') }}
        </div>

            <div class="line"></div>
            <h4>SALES RECEIPT</h4>
        </div>

        <div class="details">
            <p><strong>Bill No:</strong> {{ $myPurchase->invoice_number }}</p>
            <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($myPurchase->created_at)->format('d/m/Y H:i') }}</p>
            {{-- <p><strong>Customer:</strong> {{ $myPurchase->customer_details['name'] ?? 'Walk-in' }}</p>
            @if(isset($myPurchase->customer_details['phone_number']))
                <p><strong>Phone:</strong> {{ $myPurchase->customer_details['phone_number'] }}</p>
            @endif --}}
                       <strong>Supplier:</strong> {{ $myPurchase->purchaseParty->customer_name ?? 'N/A' }}<br>
@if($myPurchase->purchaseParty->phone_number ?? false)
    <strong>Phone:</strong> {{ $myPurchase->purchaseParty->phone_number }}<br>
@endif
@if($myPurchase->purchaseParty->address ?? false)
    <strong>Address:</strong> {{ $myPurchase->purchaseParty->address }}
@endif
        </div>

        <div class="line"></div>

        <table class="item-table">
            <thead>
                <tr>
                    <th>Qty</th>
                    <th>Item</th>
                    <th class="price-col">Amount</th>
                </tr>
            </thead>
            <tbody>
                @if (!empty($myPurchase->items) && is_iterable($myPurchase->items))
                    @foreach ($myPurchase->items as $item)
                        <tr>
                            <td class="qty-col">{{ $item->quantity }}</td>
                            <td>
                                {{ $item->product->title ?? 'Product N/A' }} <br>
                              
                            </td>
                            <td class="price-col">
                                ₹{{ number_format($item->sell_price * $item->quantity, 2) }}
                            </td>
                        </tr>
                    @endforeach
                @endif
            </tbody>
        </table>

        <div class="line"></div>

        <div class="summary">
            <p class="d-flex justify-content-between"><span>Sub Total:</span> <span class="text-right">₹ {{ number_format($myPurchase->sub_total_excluding_gst, 2) }}</span></p>
            {{-- <p class="d-flex justify-content-between"><span>Tax Amount:</span> <span class="text-right">₹ {{ number_format($myPurchase->tax_amount, 2) }}</span></p> --}}
           
           
           
               @if (auth()->user()->role == 'admin' && $is_gst == 1)
                    <p><strong>Tax:</strong> ₹{{ number_format($myPurchase->gst_total, 2) }}</p>
                @else
                    <p><strong>CGST:</strong> ₹{{ number_format($myPurchase->gst_total/2, 2) }}</p>
                    <p><strong>SGST:</strong> ₹{{ number_format($myPurchase->gst_total/2, 2) }}</p>
                @endif 


           
            @if($myPurchase->discount > 0)
                <p class="d-flex justify-content-between"><span>Discount:</span> <span class="text-right">-₹ {{ number_format($myPurchase->discount, 2) }}</span></p>
            @endif
            @if($myPurchase->additional_charge > 0)
                <p class="d-flex justify-content-between"><span>Add. Charge:</span> <span class="text-right">+₹ {{ number_format($myPurchase->additional_charge, 2) }}</span></p>
            @endif
            @if($myPurchase->cash_wallet_deduction > 0)
                <p class="d-flex justify-content-between"><span>Cash Wallet:</span> <span class="text-right">-₹ {{ number_format($myPurchase->cash_wallet_deduction, 2) }}</span></p>
            @endif
            @if($myPurchase->shopping_wallet_deduction > 0)
                <p class="d-flex justify-content-between"><span>Shop. Wallet:</span> <span class="text-right">-₹ {{ number_format($myPurchase->shopping_wallet_deduction, 2) }}</span></p>
            @endif
            <div class="line"></div>
            <p class="total-row d-flex justify-content-between"><span>TOTAL:</span> <span class="text-right">₹ {{ number_format($myPurchase->total_amount, 2) }}</span></p>
            {{-- <p class="d-flex justify-content-between"><span>Paid By:</span> <span class="text-right">{{ ucfirst($myPurchase->payment_mode) }}</span></p> --}}
            {{-- <p class="d-flex justify-content-between"><span>Received:</span> <span class="text-right">₹ {{ number_format($myPurchase->receivedAmount ?? $myPurchase->amount_payable, 2) }}</span></p> --}}
            {{-- <p class="d-flex justify-content-between"><span>Change:</span> <span class="text-right">₹ {{ number_format(($myPurchase->receivedAmount ?? $myPurchase->amount_payable) - $myPurchase->amount_payable, 2) }}</span></p> --}}
        </div>

        <div class="line"></div>

        <div class="footer">
            <p>Thank you for shopping with us!</p>
            <p>Visit again!</p>
            <p style="font-size: 10px;">Software by Your POS Solution</p>
        </div>
    </div>

    {{-- Optional Print Script --}}
    {{-- 
    <script>
        window.onload = function() {
            window.print();
            window.onafterprint = function() {
                window.close();
            };
        }
    </script>
    --}}
</body>



</html>