<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice #{{ $order_id }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .invoice-container {
            width: 100%;
            max-width: 850px;
            margin: 40px auto;
            background: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            box-sizing: border-box;
        }

        .invoice-header {
            background-color: #4CAF50;
            /* Primary Green */
            color: #ffffff;
            padding: 30px 40px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .invoice-header h1 {
            margin: 0;
            font-size: 32px;
            font-weight: 700;
        }

        .invoice-header .company-info {
            text-align: right;
            font-size: 14px;
        }

        .invoice-header .company-info strong {
            font-size: 18px;
            display: block;
            margin-bottom: 5px;
        }

        .invoice-body {
            padding: 40px;
        }

        .invoice-details,
        .billing-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            line-height: 1.8;
            font-size: 14px;
        }

        .invoice-details div,
        .billing-info div {
            flex: 1;
            padding-right: 20px;
        }

        .invoice-details div:last-child,
        .billing-info div:last-child {
            padding-right: 0;
            text-align: right;
        }

        .invoice-details strong,
        .billing-info strong {
            display: block;
            margin-bottom: 5px;
            font-size: 16px;
            color: #333;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            font-size: 14px;
        }

        .invoice-table th,
        .invoice-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        .invoice-table th {
            background-color: #f8f9fa;
            color: #555;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 13px;
        }

        .invoice-table tbody tr:last-child td {
            border-bottom: none;
        }

        .invoice-table .item-productName {
            font-weight: 600;
            color: #333;
        }

        .invoice-table .item-variant {
            font-size: 12px;
            color: #777;
            display: block;
            margin-top: 2px;
        }

        .invoice-summary {
            display: flex;
            justify-content: flex-end;
            margin-top: 20px;
        }

        .invoice-summary-table {
            width: 100%;
            max-width: 300px;
            border-collapse: collapse;
            font-size: 14px;
        }

        .invoice-summary-table td {
            padding: 10px 15px;
            border-bottom: 1px solid #e0e0e0;
        }

        .invoice-summary-table td:first-child {
            font-weight: 600;
            color: #555;
        }

        .invoice-summary-table tr:last-child td {
            border-bottom: none;
        }

        .invoice-summary-table .total-amount td {
            background-color: #e6ffe6;
            /* Light green for total */
            font-size: 16px;
            font-weight: 700;
            color: #007b00;
        }

        .invoice-footer {
            background-color: #f8f9fa;
            padding: 20px 40px;
            text-align: center;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #e0e0e0;
        }

        /* Print Specific Styles */
        @media print {
            body {
                background-color: #fff;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
            }

            .invoice-container {
                box-shadow: none;
                border: none;
                margin: 0;
                border-radius: 0;
            }

            .invoice-header {
                background-color: #4CAF50 !important;
                color: #ffffff !important;
            }

            .invoice-table th {
                background-color: #f8f9fa !important;
            }

            .invoice-summary-table .total-amount td {
                background-color: #e6ffe6 !important;
            }

            .no-print {
                display: none;
            }
        }

        .print-button-container {
            text-align: center;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        .print-button {
            padding: 10px 25px;
            font-size: 16px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .print-button:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>
  

    <div class="invoice-container">
        <div class="invoice-header">
            <h1>INVOICE</h1>
            <div class="company-info">
                <strong>{{ $company_name }}</strong>
                {{ $company_address }}<br>
                Phone: {{ $company_phone }}<br>
                Email: {{ $company_email }}
            </div>
        </div>

        <div class="invoice-body">
            <div class="invoice-details">
                <div>
                    <strong>BILL TO:</strong>
                    {{ $name }}<br>
                    Phone: {{ $phone_number }}<br>
                    @if (isset($customer['address']) && !empty(array_filter($customer['address'])))
                        <span class="address">
                            {{ $customer['address']['house_no'] ?? '' }}
                            @if (
                                !empty($customer['address']['house_no']) &&
                                    (!empty($customer['address']['road_name']) || !empty($customer['address']['landmark'])))
                                ,
                            @endif
                            {{ $customer['address']['road_name'] ?? '' }}
                            @if (!empty($customer['address']['road_name']) && !empty($customer['address']['landmark']))
                                ,
                            @endif
                            {{ $customer['address']['landmark'] ?? '' }}
                            @if (
                                (!empty($customer['address']['house_no']) ||
                                    !empty($customer['address']['road_name']) ||
                                    !empty($customer['address']['landmark'])) &&
                                    (!empty($customer['address']['district']) || !empty($customer['address']['state'])))
                                ,
                            @endif
                            {{ $customer['address']['district'] ?? '' }}
                            @if (!empty($customer['address']['district']) && !empty($customer['address']['state']))
                                ,
                            @endif
                            {{ $customer['address']['state'] ?? '' }}
                            @if (!empty($customer['address']['pin']))
                                - {{ $customer['address']['pin'] }}
                            @endif
                        </span>
                    @else
                        Address: N/A
                    @endif
                </div>
                <div>
                    <strong>INVOICE NO:<span style="font-size: 13px;"> {{ $order_id }}</span></strong>
                    <strong>DATE :<span style="font-size: 13px;">{{ $sale_date }}</span></strong>
                </div>
            </div>

            <table class="invoice-table">
                <thead>
                    <tr>
                        <th>Product Name</th>
                        <th>Qty</th>
                        <th>Unit Price (₹)</th>
                        <th>Amount (₹)</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($items as $item)
                        <tr>
                          <td>
                            <span class="item-productName">{{ $item['full_product_name'] }}</span>
                                @if ($item['full_variant_name'] !== 'N/A')
                                    <span class="item-variant">({{ $item['full_variant_name'] }})</span>
                                @endif
                                @if (!empty($item['description'])) 
                                    <p class="text-bold">IMEI/Serial.NO:&nbsp;<span>( &nbsp;{{ $item['description'] }}&nbsp; )</span></p>
                                @endif
                            </td>
                            <td>{{ $item['quantity'] }}</td>
                            <td>{{ number_format($item['sell_price'], 2) }}</td>
                            <td>{{ number_format($item['amount'], 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>


          <div class="invoice-summary">
    <table class="invoice-summary-table">
        <tr>
            <td>Subtotal:</td>
            <td>₹{{ number_format($total_amount, 2) }}</td>
        </tr>
        @if ($cash_wallet_deduction > 0)
            <tr>
                <td>Cash Wallet Used:</td>
                <td>- ₹{{ number_format($cash_wallet_deduction, 2) }}</td>
            </tr>
        @endif
        @if ($shopping_wallet_deduction > 0)
            <tr>
                <td>Shopping Wallet Used:</td>
                <td>- ₹{{ number_format($shopping_wallet_deduction, 2) }}</td>
            </tr>
        @endif
        @if ($discount > 0)
            <tr>
                <td>Discount:</td>
                <td>- ₹{{ number_format($discount, 2) }}</td>
            </tr>
        @endif
        <tr class="total-amount">
            <td>Amount Payable:</td>
            <td>₹{{ number_format($amount_payable, 2) }}</td>
        </tr>

        @php
            $beforeGstValue = 0;
            $cgst = 0;
            $sgst = 0;
            $totalGst = 0;
            $finalTotalAmount = $amount_payable;

            if ($is_gst && $amount_payable > 0 && $gst_rate > 0) {
                $beforeGstValue = round($amount_payable / (1 + $gst_rate / 100), 2);
                $totalGst = round($amount_payable - $beforeGstValue, 2);
                $cgst = round($totalGst / 2, 2);
                $sgst = round($totalGst / 2, 2);
            } else {
                $beforeGstValue = $amount_payable;
            }
        @endphp

        @if ($is_gst)
            <tr>
                <td>Before GST Value:</td>
                <td>₹{{ number_format($beforeGstValue, 2) }}</td>
            </tr>
            <tr>
                <td>SGST:</td>
                <td>+₹{{ number_format($sgst, 2) }}</td>
            </tr>
            <tr>
                <td>CGST:</td>
                <td>+₹{{ number_format($cgst, 2) }}</td>
            </tr>
            <tr class="total-amount">
                <td>Total (incl. GST):</td>
                <td>₹{{ number_format($finalTotalAmount, 2) }}</td>
            </tr>
        @endif
    </table>
</div>
</div>

        <div class="invoice-footer">
            Thank you for your business!
            <br>
            This is a system-generated invoice and does not require a signature.
        </div>
    </div>

    <div class="print-button-container no-print">
        <button class="print-button" onclick="window.print()">Print Invoice</button>
    </div>

</body>

</html>
