{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Create Purchase Invoice</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .dotted-box {
            border: 2px dashed #aaa;
            padding: 15px;
            text-align: center;
            color: #666;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .dotted-box:hover {
            background: #f8f8f8;
        }

        textarea {
            font-size: 12px;
            white-space: pre-line;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
</head>

<body x-data="invoiceProductSearch()" x-init="init">
    <div class="container my-4">
        <h4>🧾 Create Purchase Invoice</h4>
        <hr>
 <div class="mb-3">
            <label class="form-label">Bill From</label>
            <select class="form-select" name="customer_name">
                <option value="">Select Party</option>
                @foreach ($parties as $party)
                    <option value="{{ $party->customer_name }}">{{ $party->customer_name }}</option>
                @endforeach
            </select>

        </div>

        <!-- Add Item Button -->
        <div class="mb-3 text-end">
            <button class="btn btn-success" @click="openModal()">+ Add Item</button>
        </div>

        <!-- Modal -->
        <div 
            x-show="showModal"
            x-transition 
            x-cloak
            class="fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50"
        >
            <div class="bg-white w-100 modal-xl p-4 rounded shadow">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="modal-title">Add Items</h5>
                    <button type="button" class="btn-close" @click="closeModal()"></button>
                </div>
                <div class="modal-body">
                    <input type="text" class="form-control mb-3" placeholder="Search Items..." x-model="searchQuery" @input="filterItems()">

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Item Name</th>
                                <th>Item Code</th>
                                <th>Sales Price</th>
                                <th>Purchase Price</th>
                                <th>Current Stock</th>
                                <th>Add</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-for="(item, index) in filteredItems" :key="index">
                                <tr>
                                    <td x-text="item.title"></td>
                                    <td x-text="item.item_code"></td>
                                    <td x-text="item.sell_price"></td>
                                    <td x-text="item.purchase_price"></td>
                                    <td x-text="item.stock + ' PCS'"></td>
                                    <td>
                                        <button class="btn btn-sm btn-success" @click="addToInvoice(item)">+ Add</button>
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>
                <div class="text-end mt-3">
                    <button class="btn btn-secondary" @click="closeModal()">Close</button>
                </div>
            </div>
        </div>

        <!-- Added Items Table -->
        <div class="mt-4" x-show="addedItems.length > 0">
            <h5>🛒 Selected Items</h5>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Item Name</th>
                        <th>Item Code</th>
                        <th>Quantity</th>
                        <th>Purchase Price</th>
                    </tr>
                </thead>
                <tbody>
                    <template x-for="(item, index) in addedItems" :key="index">
                        <tr>
                            <td x-text="item.title"></td>
                            <td x-text="item.item_code"></td>
                            <td x-text="item.quantity"></td>
                            <td x-text="item.purchase_price"></td>
                        </tr>
                    </template>
                </tbody>
            </table>
        </div>

        <!-- Signature and Save Buttons -->
        <div class="mt-5 text-end">
            <small>Authorized signatory for <strong>SMARTWORLD</strong></small><br>
            <img src="https://i.imgur.com/JZZfK9F.png" alt="Signature" height="50">
        </div>

        <div class="mt-4 d-flex justify-content-end gap-2">
            <button class="btn btn-secondary">Save & New</button>
            <button class="btn btn-primary">Save</button>
        </div>
    </div>

    <!-- Alpine.js -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    
    <!-- Script -->
   <script>
    function invoiceProductSearch() {
        return {
            showModal: false,
            searchQuery: '',
            allItems: [],
            filteredItems: [],
            addedItems: [],

            openModal() {
                this.showModal = true;
                this.fetchProducts();
            },

            closeModal() {
                this.showModal = false;
                this.searchQuery = '';
                this.filteredItems = [];
            },

            fetchProducts() {
                fetch('/get-products')
                    .then(response => response.json())
                    .then(data => {
                        this.allItems = data;
                        this.filteredItems = data;
                    });
            },

            filterItems() {
                const query = this.searchQuery.toLowerCase();
                this.filteredItems = this.allItems.filter(item =>
                    item.title.toLowerCase().includes(query) ||
                    item.item_code.toLowerCase().includes(query)
                );
            },

            addToInvoice(item) {
                const existing = this.addedItems.find(i => i.item_code === item.item_code);
                if (!existing) {
                    this.addedItems.push({...item, quantity: 1});
                }
            }
        }
    }
</script>

</body>

</html> --}}


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Purchase Invoice</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .dotted-box {
            border: 2px dashed #aaa;
            padding: 20px;
            text-align: center;
            color: #888;
            cursor: pointer;
        }
    </style>
</head>
<body>

<div class="container my-4" x-data="invoiceProductSearch()" x-init="fetchProducts">
    <h4>🧾 Create Purchase Invoice</h4>
    <hr>

    <!-- Bill From Dropdown -->
    <div class="mb-3">
        <label class="form-label">Bill From</label>
        <select class="form-select" name="customer_name">
            <option value="">Select Party</option>
            @foreach ($parties as $party)
                <option value="{{ $party->customer_name }}">{{ $party->customer_name }}</option>
            @endforeach
        </select>
    </div>

    <!-- Add Item Button -->
    <div class="mb-3 text-end">
        <button class="btn btn-success" @click="openModal()">+ Add Item</button>
    </div>

    <!-- Modal -->
    <div x-show="showModal" x-transition x-cloak class="fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
        <div class="bg-white w-100 modal-xl p-4 rounded shadow">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="modal-title">Add Items</h5>
                <button type="button" class="btn-close" @click="closeModal()"></button>
            </div>
            <div class="modal-body">
                <input type="text" class="form-control mb-3" placeholder="Search Items..." x-model="searchQuery" @input="filterItems()">

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Item Name</th>
                            <th>Item Code</th>
                            <th>Sales Price</th>
                            <th>Purchase Price</th>
                            <th>Current Stock</th>
                            <th>Add</th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="(item, index) in filteredItems" :key="index">
                            <tr>
                                <td x-text="item.title"></td>
                                <td x-text="item.item_code"></td>
                                <td x-text="item.sell_price"></td>
                                <td x-text="item.purchase_price"></td>
                                <td x-text="item.stock + ' PCS'"></td>
                                <td>
                                    <button class="btn btn-sm btn-success" @click="addToInvoice(item)">+ Add</button>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                </table>
            </div>
            <div class="text-end mt-3">
                <button class="btn btn-secondary" @click="closeModal()">Close</button>
            </div>
        </div>
    </div>

    <!-- Selected Items -->
    <div class="mt-4" x-show="addedItems.length > 0">
        <h5>🛒 Selected Items</h5>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Item Name</th>
                    <th>Item Code</th>
                    <th>Quantity</th>
                    <th>Purchase Price</th>
                </tr>
            </thead>
            <tbody>
                <template x-for="(item, index) in addedItems" :key="index">
                    <tr>
                        <td x-text="item.title"></td>
                        <td x-text="item.item_code"></td>
                        <td x-text="item.quantity"></td>
                        <td x-text="item.purchase_price"></td>
                    </tr>
                </template>
            </tbody>
        </table>
    </div>

    <!-- Footer -->
    <div class="mt-5 text-end">
        <small>Authorized signatory for <strong>SMARTWORLD</strong></small><br>
        <img src="https://i.imgur.com/JZZfK9F.png" alt="Signature" height="50">
    </div>

    <div class="mt-4 d-flex justify-content-end gap-2">
        <button class="btn btn-secondary">Save & New</button>
        <button class="btn btn-primary">Save</button>
    </div>
</div>

<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

<!-- Script -->
<script>
    function invoiceProductSearch() {
        return {
            showModal: false,
            searchQuery: '',
            allItems: [],
            filteredItems: [],
            addedItems: [],

            openModal() {
                this.showModal = true;
                this.filterItems(); // optional: apply current search
            },

            closeModal() {
                this.showModal = false;
                this.searchQuery = '';
                this.filteredItems = this.allItems;
            },

            fetchProducts() {
                fetch('/get-products')
                    .then(response => response.json())
                    .then(data => {
                        console.log('Fetched Products:', data); // Debug
                        this.allItems = data;
                        this.filteredItems = data;
                    })
                    .catch(error => console.error('Error fetching products:', error));
            },

            filterItems() {
                const query = this.searchQuery.toLowerCase();
                this.filteredItems = this.allItems.filter(item =>
                    item.title.toLowerCase().includes(query) ||
                    item.item_code.toLowerCase().includes(query)
                );
            },

            addToInvoice(item) {
                const existing = this.addedItems.find(i => i.item_code === item.item_code);
                if (!existing) {
                    this.addedItems.push({...item, quantity: 1});
                }
            }
        }
    }
</script>

</body>
</html>

