@extends('admin.layouts')
@section('title', 'Purchase Invoice')

@section('header')

    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/responsive.bootstrap.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/buttons.dataTables.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
   
   <style>
        table td,
        table th {
            vertical-align: middle;
            white-space: normal !important;
        }
    </style>

@endsection

@section('content')

    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Purchase Invoice</h3>
                <div>
                    <a type="button" href="{{ route('create_invoice') }}" class="btn btn-primary feature-btn">
                        <i class="fa-solid fa-circle-plus me-2"></i>Create Invoice
                    </a>
                </div>
            </div>
        </div>

        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">

                        <table id="data-table" class="table align-middle table-responsive" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Date</th>
                                    <th>Purchase Invoice Number</th>
                                    <th>Party Name</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($purchases as $purchase)
                                    @php
                                        $party = $purchase->purchaseParty;
                                        $dueIn = \Carbon\Carbon::parse($purchase->purchase_date)->diffInDays(now());
                                    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ \Carbon\Carbon::parse($purchase->purchase_date)->format('d-m-Y') }}</td>
                                        <td>{{ $purchase->invoice_number }}</td>
                                        <td>{{ $party->customer_name ?? 'N/A' }}</td>
                                        <td>₹{{ number_format($purchase->total_amount, 2) }}</td>
                                        <td>
                                            <button class="btn btn-sm btn-success" disabled>Paid</button>
                                        </td>
                                        <td>
                                            {{-- <a href="{{ route('invoice_a4_purchase', ['id' => $purchase->id]) }}"
                                                target="_blank" class="btn btn-info btn-sm">View Invoice</a>
                                          --}}
                                                   <a href="{{ route('invoice_a4_purchase', ['orderId' => $purchase->id]) }}"
                                                    target="_blank" class="btn btn-info btn-sm">View Invoice</a>
                                         
                                                <a href="{{ route('purchase.edit', ['id' => $purchase->id]) }}"
                                                class="btn btn-warning btn-sm">Edit</a>

                                        </td>

                                    </tr>
                                @endforeach
                            </tbody>

                        </table>

                    </div>
                </div>
            </div>
        </div>

</div>@endsection

@section('footer')

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script type="text/javascript" src="{{ asset('/assets/js/datatable/jquery.dataTables.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.bootstrap5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.responsive.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.buttons.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/buttons.html5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/buttons.print.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/jszip.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/pdfmake.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/vfs_fonts.js') }}"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#data-table').DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ],

            });
        });
    </script>

@endsection
