@extends('admin.layouts')
@section('title', 'Recent Orders')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')

    <div class="container-fluid page-wrapper">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Recent Orders</h3>
            </div>

            <div class="row mt-4">
                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <a href="{{ route('recent_orders') }}" class="text-decoration-none">
                        <div class="card border-0 dashboard-widget-card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-4 text-center">
                                        <strong>
                                            <p class="mb-0 d-card-para-title">Recent Orders</p>
                                        </strong>
                                        <h2 class="mb-0 d-card-inner-head">{{ $recentOrderCount }}</h2>
                                    </div>
                                    <div class="d-card-icon">
                                        <img class="dashboard-icon-img"
                                            src="{{ asset('/assets/images/icons/envelope.svg') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <a href="{{ route('accept_orders') }}" class="text-decoration-none">
                        <div class="card border-0 dashboard-widget-card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-4 text-center">
                                        <p class="mb-0 d-card-para-title">Accepted Orders</p>
                                        <h2 class="mb-0 d-card-inner-head">{{ $acceptedOrderCount }}</h2>
                                    </div>
                                    <div class="d-card-icon">
                                        <img class="dashboard-icon-img"
                                            src="{{ asset('/assets/images/icons/envelope.svg') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <div class="card border-0 dashboard-widget-card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="me-4 text-center">
                                    <p class="mb-0 d-card-para-title">Shipped Orders</p>
                                    <h2 class="mb-0 d-card-inner-head">{{ $shippedOrderCount ?? '0' }}</h2>
                                </div>
                                <div class="d-card-icon">
                                    <img class="dashboard-icon-img" src="{{ asset('/assets/images/icons/envelope.svg') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <div class="card border-0 dashboard-widget-card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="me-4 text-center">
                                    <p class="mb-0 d-card-para-title">Delivered Orders</p>
                                    <h2 class="mb-0 d-card-inner-head">{{ $deliveredOrderCount ?? '0' }}</h2>
                                </div>
                                <div class="d-card-icon">
                                    <img class="dashboard-icon-img" src="{{ asset('/assets/images/icons/envelope.svg') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <a href="{{ route('rejected_orders') }}" class="text-decoration-none">
                        <div class="card border-0 dashboard-widget-card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-4 text-center">
                                        <p class="mb-0 d-card-para-title">Cancelled Orders</p>
                                        <h2 class="mb-0 d-card-inner-head">{{ $cancelledOrderCount ?? '0' }}</h2>
                                    </div>
                                    <div class="d-card-icon">
                                        <img class="dashboard-icon-img"
                                            src="{{ asset('/assets/images/icons/envelope.svg') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>


        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label for="fromDate" class="form-label">From Date:</label>
                                <input type="date" class="form-control" id="fromDate">
                            </div>
                            <div class="col-md-3">
                                <label for="toDate" class="form-label">To Date:</label>
                                <input type="date" class="form-control" id="toDate">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="button" class="btn btn-primary me-2" id="filterBtn">Filter</button>
                                <button type="button" class="btn btn-secondary" id="resetBtn">Reset</button>
                            </div>
                        </div>
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER ID</th>
                                    <th>USER DETAILS</th>
                                    <th>MEMBERSHIP</th>
                                    <th>AMOUNT</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($recent_orders as $key => $recent_order)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ \Carbon\Carbon::parse($recent_order->order_date)->format('Y-m-d') }}
                                        </td>
                                        <td>{{ $recent_order->order_random_id }}</td>
                                        <td>
                                            <div>{{ $recent_order->user_id ?? 'NA' }}</div>
                                        </td>
                                        <td>
                                            @if ($recent_order->user)
                                                <div>Name: {{ $recent_order->user->name }}</div>
                                                <div>Email: {{ $recent_order->user->email }}</div>
                                                <div>Phone: {{ $recent_order->user->phone_number }}</div>
                                            @else
                                                <div>NA</div>
                                            @endif
                                        </td>
                                        <td>{{ $recent_order->user->membership }}</td>
                                        <td><span>₹{{ $recent_order->amount }}</span></td>
                                        <td>
                                            <a href="{{ route('view_recent_orders', ['order_random_id' => $recent_order->order_random_id]) }}"
                                                class="btn btn-primary btn-sm">
                                                <i class="fa-regular fa-eye me-2"></i>View Order
                                            </a>

                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @foreach ($recent_orders as $recent_order)
            <div class="modal fade zoom-in" id="AcceptModal{{ $recent_order->id }}" tabindex="-1"
                aria-labelledby="AcceptModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="text-center">
                                <img class="mb-3" style="height: 75px;"
                                    src="{{ asset('/assets/images/gif/accept.png') }}">
                                <p class="my-4 are-you-sure">Are You Sure</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to accept this order?
                                </p>
                            </div>
                            <form action="{{ route('accept_order') }}" method="POST">
                                @csrf
                                <input type="hidden" name="order_id" value="{{ $recent_order->id }}">
                                <div class="d-flex align-items-center mt-5 mb-3">
                                    <button type="button" data-bs-dismiss="modal"
                                        class="btn btn-light cancel-btn me-3">Cancel</button>
                                    <button type="submit" class="btn btn-primary yes-btn"><i
                                            class="fa-regular fa-circle-check me-2"></i>Yes, Accept It!</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach

        @foreach ($recent_orders as $recent_order)
            <div class="modal fade zoom-in" id="DeclineModal{{ $recent_order->id }}" tabindex="-1"
                aria-labelledby="DeclineModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="text-center">
                                <img class="mb-3" style="height:75px;"
                                    src="{{ asset('/assets/images/gif/reject.png') }}">
                                <p class="my-4 are-you-sure">Are You Sure</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to decline this
                                    order?</p>
                            </div>
                            <form action="{{ route('decline_order') }}" method="POST">
                                @csrf
                                <input type="hidden" name="order_id" value="{{ $recent_order->id }}">
                                <div class="d-flex align-items-center mt-5 mb-3">
                                    <button type="button" data-bs-dismiss="modal"
                                        class="btn btn-light cancel-btn me-3">Cancel</button>
                                    <button type="submit" class="btn btn-primary yes-btn"><i
                                            class="fa-regular fa-circle-check me-2"></i>Yes, Decline It!</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>




@endsection
@section('footer')


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    {{-- <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script> --}}
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

    <script>
        $(document).ready(function() {
            let table = $('#data-table').DataTable({
                responsive: true
            });

            $.fn.dataTable.ext.search.push(
                function(settings, data, dataIndex) {
                    let fromDate = $('#fromDate').val();
                    let toDate = $('#toDate').val();
                    let orderDate = data[1]; 

                    if (!fromDate && !toDate) {
                        return true;
                    }

                    let momentOrderDate = moment(orderDate, 'YYYY-MM-DD');
                    let fromMoment = fromDate ? moment(fromDate) : null;
                    let toMoment = toDate ? moment(toDate) : null;

                    if (fromDate && !toMoment && momentOrderDate.isSameOrAfter(fromMoment, 'day')) {
                        return true;
                    }

                    if (!fromMoment && toDate && momentOrderDate.isSameOrBefore(toMoment, 'day')) {
                        return true;
                    }

                    if (fromMoment && toMoment && momentOrderDate.isSameOrAfter(fromMoment, 'day') &&
                        momentOrderDate.isSameOrBefore(toMoment, 'day')) {
                        return true;
                    }

                    return false;
                }
            );

            $('#filterBtn').on('click', function() {
                table.draw();
            });

            $('#resetBtn').on('click', function() {
                $('#fromDate').val('');
                $('#toDate').val('');
                table.draw();
            });
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

@endsection
