@extends('admin.layouts')
@section('title', 'Notification')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">
<style>
    .referral-container {
    max-width: 600px;
    margin: 30px auto;
    background: #fff;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
}

.page-top-heading {
    font-size: 24px;
    font-weight: bold;
    color: #333;
}

.wallet-card {
    background: #f9f9f9;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.input-group {
    position: relative;
}

.input-group input {
    padding: 12px;
    font-size: 16px;
    border-radius: 5px;
    border: 1px solid #ccc;
    width: 100%;
}

.input-group button {
    background: #007bff;
    color: white;
    border: none;
    padding: 12px 20px;
    font-size: 14px;
    border-radius: 5px;
    cursor: pointer;
    transition: 0.3s;
}

.input-group button:hover {
    background: #0056b3;
}

.referralimage {
    width: 50px;
    height: auto;
    margin-bottom: 10px;
}

</style>
@endsection
@section('content')



<div class="container-fluid page-wrapper category-container">

    <div class="container-fluid page-wrapper category-container">
        <div class="referral-container">
            <div class="d-flex align-items-center justify-content-between">
                <h3 class="page-top-heading">Referral Link</h3>
            </div>
    
            <div class="wallet-card mt-3 p-3 text-center">
                <p class="mt-2"><strong>Your Referral Link:</strong></p>
                <div class="input-group">
                    <input type="text" id="referralLink" class="form-control" value="{{ $url }}" readonly>
                    <button id="copyLink">Copy</button>
                </div>
            </div>
        </div>
    </div>
    
   
   
    
</div>
<!-- end container fluid -->




@endsection
@section('footer')


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>
  document.getElementById("copyLink").addEventListener("click", function() {
    var copyText = document.getElementById("referralLink");
    navigator.clipboard.writeText(copyText.value).then(() => {
        alert("Referral link copied to clipboard!");
    }).catch(err => {
        console.error("Failed to copy: ", err);
    });
});

</script>
@endsection


