<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Refund & Replacement Policy – AdBazzar</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.7;
            color: #343a40;
            background-color: #f8f9fa;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Montserrat', sans-serif;
            color: #138FA6 !important;
        }
        .container {
            flex: 1;
            background-color: #ffffff;
            border-radius: 0.75rem;
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.08);
            padding: 2.5rem;
            margin-top: 3rem;
            margin-bottom: 3rem;
        }
        .header-title {
            font-size: clamp(2rem, 4vw, 3rem);
            font-weight: 700;
            margin-bottom: 2.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #e9ecef;
        }
        .section-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 0.75rem;
            font-size: 1.6em;
            color: #138FA6;
        }
        p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }
        ol {
            list-style-type: none; /* Remove default numbering */
            padding-left: 0;
        }
        ol > li { /* Target direct children of ol */
            margin-bottom: 2.5rem; /* Space between major policy points */
        }
        ul { /* For nested lists within cards */
            list-style-type: none;
            padding-left: 0;
            margin-top: 1rem;
        }
        ul li {
            margin-bottom: 0.6rem;
            font-size: 1.05rem;
            position: relative;
            padding-left: 1.8rem;
        }
        ul li::before {
            content: "\f05a"; /* Bootstrap icon for info-circle */
            font-family: "bootstrap-icons";
            color: #138FA6;
            font-weight: bold;
            display: inline-block;
            position: absolute;
            left: 0;
            top: 0.1em;
            font-size: 1.1em;
        }
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.05);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            padding: 2rem; /* Consistent padding inside cards */
        }
        .card:hover {
            transform: translateY(-0.25rem);
            box-shadow: 0 0.5rem 1.25rem rgba(0, 0, 0, 0.09);
        }
        .footer {
            margin-top: 3rem;
            padding: 1.5rem;
            text-align: center;
            color: #6c757d;
            font-size: 0.875rem;
            background-color: #e9ecef;
            border-top: 1px solid #dee2e6;
        }

        /* Responsive adjustments */
        @media (max-width: 767.98px) {
            .container {
                margin-top: 1.5rem;
                margin-bottom: 1.5rem;
                padding: 1.5rem;
                border-radius: 0;
                box-shadow: none;
            }
            .header-title {
                font-size: 1.8rem;
                text-align: center;
                margin-bottom: 2rem;
            }
            .section-title {
                font-size: 1.5rem;
                justify-content: center;
                text-align: center;
            }
            ul li {
                padding-left: 1.5rem;
            }
            ul li::before {
                font-size: 1em;
                left: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="header-title text-center">Refund & Replacement Policy</h1>

        <ol>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-truck"></i>Product Delivery & Charges:</h2>
                    <ul class="list-unstyled">
                        <li>A <strong>delivery charge of ₹80</strong> will be applied for orders below <strong>₹1000</strong>.</li>
                        <li>If a customer fails to receive the product and it returns to us, a refund will be initiated once the product is successfully received back at our facility.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-award-fill"></i>Membership Plans:</h2>
                    <ul class="list-unstyled">
                        <li>Upon purchasing a membership plan, all the associated benefits are provided immediately upon activation.</li>
                        <li>Once activated, membership plans are <strong>non-refundable and non-cancellable</strong> due to the immediate provision of benefits.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-arrow-repeat"></i>Damaged Product Replacement:</h2>
                    <ul class="list-unstyled">
                        <li>If you receive a <strong>damaged or defective product</strong>, you must send clear photos and a description of the issue to our admin team <strong>within 2 days of delivery</strong>.</li>
                        <li><strong>Requests made after this 2-day period will not be accepted.</strong></li>
                        <li>If the damage is verified, a replacement product will be shipped to you within <strong>3-7 working days</strong>.</li>
                        <li>Alternatively, for a faster resolution, you can visit our <strong>AdBazzar offline store</strong> to get the product replaced immediately.</li>
                        <li>Replacement is only applicable if the returned product matches the originally shipped item in terms of model, color, and specifications.</li>
                        <li>Any alterations, signs of use beyond inspection, or differences in the returned product from what was originally delivered will result in rejection of the replacement request.</li>
                    </ul>
                </div>
            </li>
        </ol>
    </div>

    <footer class="footer">
        &copy; 2025 AdBazzar. All rights reserved.
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>