@extends('admin.layouts')
@section('title', 'Recent Orders')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">  Rejected History</h3>
               
            </div>
        </div>

        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>DATE</th>
                                    <th>USER ID</th>
                                    <th>NAME</th>
                                    <th>MEMBERSHIP ID</th>
                                    <th>TITLE</th>
                                    <th>AMOUNT</th>
                                    <th>TRANSACTION ID</th>
                                    <th>PAYMENT IMAGE</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($datatables as $data)
                                    <tr>

                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y') }}</td>
                                        <td>{{ $data->user_id }}</td>
                                        <td>{{ $data->name }}</td>
                                        <td>{{ $data->membership_id }}</td>
                                        <td>{{ $data->title }}</td>
                                        <td>{{ $data->amount }}</td>
                                        <td>{{ $data->transaction_id }}</td>

                                        {{-- <td>
                                            <a href="{{ asset($data->payment_image) }}" target="_blank">
                                                <img src="{{ asset($data->payment_image) }}" alt="Proof Image"
                                                    style="width: 100px; height: auto;">
                                            </a>
                                        </td> --}}
                                        <td>
                                            @if($data->payment_image)
                                                <a href="{{ asset($data->payment_image) }}" target="_blank">
                                                    <img src="{{ asset($data->payment_image) }}" alt="Proof Image"
                                                        style="width: 100px; height: auto;">
                                                </a>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        
                                      
                                    </tr>
                                @endforeach
                            </tbody>


                        </table>

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->

      


    </div>
    <!-- end container fluid -->




@endsection
@section('footer')


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>



  
@endsection
