@extends('admin.layouts')
@section('title', 'User Management')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')

<div class="container-fluid page-wrapper category-container">
    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Rejected Withdraw History</h3>
        </div>
    </div>

    <!-- Table Row -->
    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="card datatable-card">
                <div class="card-body">
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>DATE & TIME</th>
                                <th>Email ID</th>
                                <th>Request Amount</th>
                                <th>Bank Details</th>
                                <th>Type</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($withdrawRequests as $key => $request)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $request->created_at->format('m/d/Y H:i:s') }}</td>
                                    <td>{{ $request->user->email ?? 'N/A' }}</td>
                                    <td>₹{{ number_format($request->amount, 2) }}</td>
                                    <td>
                                        @if ($request->type == 'bank' && $request->bankDetails)
                                            <strong>Name:</strong> {{ $request->bankDetails->account_holder_name }}<br>
                                            <strong>Bank:</strong> {{ $request->bankDetails->bank_name }}<br>
                                            <strong>A/C No:</strong> {{ $request->bankDetails->account_number }}<br>
                                            <strong>IFSC:</strong> {{ $request->bankDetails->ifsc_code }}<br>
                                            <strong>Branch:</strong> {{ $request->bankDetails->branch }}
                                        @elseif ($request->type == 'gpay')
                                            <strong>GPay Number:</strong> {{ $request->gpay_number }}
                                        @else
                                            No Details Available
                                        @endif
                                    </td>
                                    <td>{{ ucfirst($request->type) }}</td>
                                   
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

   

</div>
@endsection

@section('footer')

<!-- Bootstrap & jQuery -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- DataTable JS -->
<script src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
<script src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>

<script>
    function setAcceptId(element) {
        document.getElementById("accept_id").value = element.getAttribute("data-user-id");
    }

    function setRejectId(element) {
        document.getElementById("reject_id").value = element.getAttribute("data-user-id");
    }

    $(document).ready(function () {
        const table = $('#data-table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'Export to Excel',
                    filename: 'Withdraw_History',
                    title: null,
                    className: 'd-none',
                    exportOptions: {
                        columns: ':visible'
                    }
                }
            ],
            responsive: true
        });

        $('.excel-btn').on('click', function () {
            table.button('.buttons-excel').trigger();
        });
    });
</script>

@endsection
