 @extends('admin.layouts')
 @section('title', 'Offline Sales')
 @section('header')
     <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
     <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
     <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">
     <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
 @endsection
 @section('content')

     <div class="container-fluid page-wrapper category-container">
         <h3 class="page-top-heading mb-4">Offline Sales</h3>

         <div class="card shadow-sm mb-4 p-2">
             <div class="card-body">
                 <h5 class="card-title mb-3">Customer Details</h5>
                 <div class="mb-3">
                     <label class="form-label" for="user_id">Customer User ID:</label>
                     <input class="form-control" type="text" id="user_id" name="user_id" required />
                     <div id="customer_details_card" class="card mt-2" style="display: none;">
                         <div class="card-body py-2">
                             <h6 class="card-title mb-1">Customer Information:</h6>
                             <p class="card-text mb-0" id="user_name_display_name"></p>
                             <p class="card-text mb-0" id="user_name_display_phone"></p>
                             <p class="card-text mb-0" id="user_name_display_address"></p>
                         </div>
                     </div>
                 </div>
                 <h5 class="card-title mb-3">Product Details</h5>
                 <div class="row">
                     <div class="mb-3 col-lg-6">
                         <label class="form-label" for="product_id">Product ID/HSN:</label>
                         <div class="input-group">
                             <input class="form-control" type="text" id="product_id" name="product_id" />

                         </div>
                     </div>

{{-- <input type="hidden" name="admin_role" id="admin_role" value="{{ Auth::user()->role }}"> --}}

<input type="hidden" name="admin_role" id="admin_role" value="{{ Auth::user()->role ?? '' }}">

                     <div class="mb-3 col-lg-6" id="variant_container" style="display: none;">
                         <label class="form-label" for="variant_select">Select Variant:</label>
                         <select class="form-select" id="variant_select" onchange="onVariantChange()">
                             <option value="" disabled selected>Select a variant</option>
                         </select>
                     </div>

                     <div class="mb-3 col-lg-6">
                         <label class="form-label" for="product_title">Product Title:</label>
                         <input class="form-control" type="text" id="product_title" name="product_title" readonly />
                     </div>

                     <div class="mb-3 col-lg-6">
                         <label class="form-label" for="sell_price">Sell Price:</label>
                         <div class="input-group">
                             <span class="input-group-text">₹</span>
                             <input class="form-control" type="number" id="sell_price" name="sell_price" step="0.01"
                                 readonly />
                         </div>
                     </div>

                     <div class="mb-3 col-lg-6">
                         <label class="form-label" for="quantity">Quantity:</label>
                         <input class="form-control" type="number" id="quantity" name="quantity" value="1"
                             min="1" onchange="validateQuantity()" onkeyup="validateQuantity()" />
                     </div>

                    <div class="form-group mt-2">
                        <label for="product_description">Description (IMEI / Serial No.)</label>
                        <input type="text" class="form-control" id="product_description" placeholder="Optional">
                    </div>

                     <div class="mt-3">
                         <button type="button" class="btn btn-primary" onclick="addProductToTable()">Add to Sale</button>
                     </div>
                 </div>
             </div>
         </div>

         <div class="card shadow-sm mb-4 p-2">
             <h5 class="card-title mb-3">Sale Items</h5>
             <div class="table-responsive">
                 <table id="sale_table" class="table table-bordered table-striped mt-3">
                     <thead>
                         <tr>
                             <th>Product ID</th>
                             <th>Product Title</th>
                             <th>Variant</th>
                             <th>Sell Price</th>
                             <th>Quantity</th>
                             <th>Amount</th>
                             <th>Description</th>
                             <th>Action</th>
                         </tr>
                     </thead>
                     <tbody id="sale_items"></tbody>
                 </table>
             </div>

             <div class="mt-3">
                 <strong>Total Amount:</strong> ₹<span id="total_amount">0.00</span>
             </div>
         </div>

         <div class="card shadow-sm mb-4 p-2">
             <div class="card-body">

                 <h5 class="card-title mb-3">Payment Options & Order Summary</h5>
                 <div class="row d-flex justify-content-evenly">
                     <div class=" col-lg-6 mb-3">
                         <div class="form-check">
                             <input class="form-check-input" type="checkbox" id="use_cash_wallet"
                                 onchange="updateOrderSummary()">
                             <label class="form-check-label" for="use_cash_wallet">Use Cash Wallet (Balance: ₹<span
                                     id="available_cash_wallet">0.00</span>)</label>
                         </div>
                         <div class="form-check">
                             <input class="form-check-input" type="checkbox" id="use_shopping_wallet"
                                 onchange="updateOrderSummary()">
                             <label class="form-check-label" for="use_shopping_wallet">Use Shopping Wallet (Balance:
                                 ₹<span id="available_shopping_wallet">0.00</span>)</label>
                         </div>
                     </div>
                     <div class=" col-lg-6 mb-3">
                         <label class="form-label" for="final_payment_method">Final Payment Method:</label>
                         <select class="form-select" id="final_payment_method">
                             <option value="cash">Cash</option>
                             <option value="card">Card</option>
                             <option value="upi">UPI</option>
                         </select>
                     </div>
                 </div>


                 <h5 class="mt-4">Order Summary</h5>
                 <div class="table-responsive">
                     <table class="table table-sm table-bordered">
                         <tbody>
                             <tr>
                                 <th>Total Amount</th>
                                 <td>₹<span id="summary_total_amount">0.00</span></td>
                             </tr>
                             <tr>
                                 <th>Cash Wallet Used</th>
                                 <td>₹<span id="summary_cash_wallet">0.00</span></td>
                             </tr>
                             <tr>
                                 <th>Shopping Wallet Used</th>
                                 <td>₹<span id="summary_shopping_wallet">0.00</span></td>
                             </tr>
                             <tr>
                                <th>Discount</th>
                                <td>
                                    ₹<input type="number" class="form-control form-control-sm d-inline-block w-auto"
                                        id="summary_discount" value="" min="0" step="0.01" onchange="updateOrderSummary()">
                                </td>
                            </tr>
                             <tr>
                                 <th>Amount Payable</th>
                                 <td>₹<span id="summary_amount_payable">0.00</span></td>
                             </tr>
                         </tbody>
                     </table>
                 </div>


                 <button type="button" class="btn btn-success mt-3" onclick="placeOrder()">Place Order</button>
             </div>
         </div>
     </div>
 @endsection
 @section('footer')
     <script src="https://code.jquery.com/jquery-3.6.0.min.js"
         integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
     {{-- DataTables scripts are not strictly necessary for this form, but kept as per your original code --}}
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
     <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>
     <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>




     <script>
    const userIdField = document.getElementById('user_id');
    const customerDetailsCard = document.getElementById('customer_details_card');
    const userNameDisplayName = document.getElementById('user_name_display_name');
    const userNameDisplayPhone = document.getElementById('user_name_display_phone');
    const userNameDisplayAddress = document.getElementById('user_name_display_address');

    const productIDField = document.getElementById('product_id');
    const variantContainer = document.getElementById('variant_container');
    const variantSelect = document.getElementById('variant_select');
    const productTitleField = document.getElementById('product_title');
    const sellPriceField = document.getElementById('sell_price');
    const quantityField = document.getElementById('quantity');
    const descriptionField = document.getElementById('product_description'); // <-- Added
    const saleItemsTable = document.getElementById('sale_items');
    const totalAmountSpan = document.getElementById('total_amount');
    const adminRoleField = document.getElementById('admin_role');

    const useCashWalletCheckbox = document.getElementById('use_cash_wallet');
    const useShoppingWalletCheckbox = document.getElementById('use_shopping_wallet');
    const availableCashWalletSpan = document.getElementById('available_cash_wallet');
    const availableShoppingWalletSpan = document.getElementById('available_shopping_wallet');
    const finalPaymentMethodSelect = document.getElementById('final_payment_method');

    const summaryTotalAmountSpan = document.getElementById('summary_total_amount');
    const summaryCashWalletSpan = document.getElementById('summary_cash_wallet');
    const summaryShoppingWalletSpan = document.getElementById('summary_shopping_wallet');
    const summaryAmountPayableSpan = document.getElementById('summary_amount_payable');
    const discountInput = document.getElementById('summary_discount');

    let currentProduct = null;
    let saleItems = [];
    let userWalletBalances = {
        cash_wallet: 0,
        shopping_wallet: 0
    };
    let activeUserId = null;
    let activeUserDetails = null;

    async function fetchUserAndWalletDetails() {
        const input = userIdField.value.trim();
        if (!input) return clearUserDetails();
        if (input === activeUserId) return;

        let url = /^\d{10}$/.test(input)
            ? `/admin/getUserDetailsAndWalletByPhone/${input}`
            : `/admin/getUserDetailsAndWallet/${input}`;

        try {
            const response = await fetch(url);
            const data = await response.json();
            if (!response.ok) {
                alert(data.message || 'User not found.');
                return clearUserDetails('User not found.');
            }

            const address = data.user.address;
            let formattedAddress = 'N/A';

            if (address) {
                formattedAddress =
                    `${address.house_no || ''}, ${address.road_name || ''}, ${address.landmark || ''}, ${address.district || ''}, ${address.state || ''} - ${address.pin || ''}`;
                formattedAddress = formattedAddress.replace(/,(\s*,)+/g, ',').replace(/^,|,$/g, '').trim();
            }

            userNameDisplayName.innerHTML = `<strong>Name:</strong> ${data.user.name}`;
            userNameDisplayPhone.innerHTML = `<strong>Phone:</strong> ${data.user.phone_number}`;
            userNameDisplayAddress.innerHTML = `<strong>Address:</strong> ${formattedAddress}`;
            customerDetailsCard.style.display = 'block';

            userWalletBalances = {
                cash_wallet: parseFloat(data.wallet.cash_wallet),
                shopping_wallet: parseFloat(data.wallet.shopping_wallet)
            };

            activeUserId = data.user.user_id;
            activeUserDetails = data.user;

            availableCashWalletSpan.textContent = userWalletBalances.cash_wallet.toFixed(2);
            availableShoppingWalletSpan.textContent = userWalletBalances.shopping_wallet.toFixed(2);
            updateOrderSummary();
        } catch (error) {
            console.error('Fetch user error:', error);
            alert('Error fetching user details.');
            clearUserDetails();
        }
    }

    function clearUserDetails(message = '') {
        userNameDisplayName.innerHTML = message ? `<strong>${message}</strong>` : '';
        userNameDisplayPhone.innerHTML = '';
        userNameDisplayAddress.innerHTML = '';
        customerDetailsCard.style.display = 'none';
        userWalletBalances = { cash_wallet: 0, shopping_wallet: 0 };
        availableCashWalletSpan.textContent = '0.00';
        availableShoppingWalletSpan.textContent = '0.00';
        activeUserId = null;
        activeUserDetails = null;
        updateOrderSummary();
    }

    userIdField.addEventListener('blur', fetchUserAndWalletDetails);
    userIdField.addEventListener('keypress', e => {
        if (e.key === 'Enter') fetchUserAndWalletDetails();
    });

    productIDField.addEventListener('blur', fetchProductDetails);
    productIDField.addEventListener('keypress', e => {
        if (e.key === 'Enter') fetchProductDetails();
    });

    async function fetchProductDetails() {
        const productId = productIDField.value.trim();
        if (!productId) return;

        try {
            const response = await fetch(`/admin/products/${productId}`);
            const product = await response.json();
            if (!response.ok) {
                alert(product.message || 'Product not found.');
                return resetProductFields();
            }

            currentProduct = product;
            currentProduct.shop_wallet = parseFloat(product.shop_wallet || 0);
            productTitleField.value = product.title;

            if (product.variants && product.variants.length > 0) {
                variantContainer.style.display = 'block';
                variantSelect.innerHTML = '<option value="">-- Select Variant --</option>';
                product.variants.forEach(v => {
                    const option = document.createElement('option');
                    option.value = v.id;
                    option.textContent = `${v.variant_name} (₹${parseFloat(v.sell_price).toFixed(2)})`;
                    variantSelect.appendChild(option);
                });
                sellPriceField.value = parseFloat(product.sell_price).toFixed(2);
            } else {
                variantContainer.style.display = 'none';
                variantSelect.innerHTML = '';
                sellPriceField.value = parseFloat(product.sell_price).toFixed(2);
            }

            quantityField.value = 1;
            descriptionField.value = ''; // Clear description
        } catch (err) {
            console.error('Product fetch error:', err);
            alert('Product not found or error occurred.');
            resetProductFields();
        }
    }

    function resetProductFields() {
        currentProduct = null;
        productIDField.value = '';
        productTitleField.value = '';
        sellPriceField.value = '';
        quantityField.value = 1;
        descriptionField.value = '';
        variantSelect.innerHTML = '';
        variantContainer.style.display = 'none';
    }

    function onVariantChange() {
        const selectedVariantId = variantSelect.value;
        if (!selectedVariantId) {
            sellPriceField.value = parseFloat(currentProduct.sell_price).toFixed(2);
            return;
        }
        const variant = currentProduct.variants.find(v => v.id.toString() === selectedVariantId);
        sellPriceField.value = variant ? parseFloat(variant.sell_price).toFixed(2) : parseFloat(currentProduct.sell_price).toFixed(2);
    }

    function validateQuantity() {
        let quantity = parseInt(quantityField.value);
        quantityField.value = isNaN(quantity) || quantity < 1 ? 1 : quantity;
    }

    function addProductToTable() {
        if (!currentProduct) return alert('Fetch a product first.');

        const productId = productIDField.value.trim();
        const productTitle = productTitleField.value.trim();
        const sellPrice = parseFloat(sellPriceField.value);
        const quantity = parseInt(quantityField.value);
        const selectedVariantId = variantSelect.value;
        const selectedVariantName = variantSelect.options[variantSelect.selectedIndex]?.textContent.split('(')[0].trim() || 'N/A';
        const description = descriptionField.value.trim();

        if (isNaN(sellPrice) || sellPrice <= 0 || isNaN(quantity) || quantity < 1) {
            return alert('Invalid price or quantity.');
        }

        const amount = sellPrice * quantity;
        const itemShopWalletValue = currentProduct.shop_wallet || 0;
        const effectiveShopWalletLimit = itemShopWalletValue * quantity;

        const existingIndex = saleItems.findIndex(item =>
            item.product_id === productId &&
            item.variant_id === (selectedVariantId || null) &&
            item.description === description // include description in uniqueness
        );

        if (existingIndex > -1) {
            saleItems[existingIndex].quantity += quantity;
            saleItems[existingIndex].amount += amount;
            saleItems[existingIndex].effective_shop_wallet_limit += effectiveShopWalletLimit;
            const row = saleItemsTable.rows[existingIndex];
            row.cells[4].textContent = saleItems[existingIndex].quantity;
            row.cells[5].textContent = `₹${saleItems[existingIndex].amount.toFixed(2)}`;
        } else {
            const item = {
                product_id: productId,
                product_title: productTitle,
                variant_id: selectedVariantId || null,
                variant_name: selectedVariantName,
                sell_price: sellPrice,
                quantity,
                amount,
                shop_wallet_value: itemShopWalletValue,
                effective_shop_wallet_limit: effectiveShopWalletLimit,
                description: description // Save it
            };
            saleItems.push(item);

            const row = saleItemsTable.insertRow();
            row.insertCell().textContent = item.product_id;
            row.insertCell().textContent = item.product_title;
            row.insertCell().textContent = item.variant_name;
            row.insertCell().textContent = `₹${item.sell_price.toFixed(2)}`;
            row.insertCell().textContent = item.quantity;
            row.insertCell().textContent = `₹${item.amount.toFixed(2)}`;
            row.insertCell().textContent = item.description || '—';
            const actionCell = row.insertCell();
            const removeBtn = document.createElement('button');
            removeBtn.textContent = 'Remove';
            removeBtn.classList.add('btn', 'btn-danger', 'btn-sm');
            removeBtn.onclick = () => removeProductFromTable(row, item);
            actionCell.appendChild(removeBtn);
        }

        updateOrderSummary();
        resetProductFields();
    }

    function removeProductFromTable(row, itemToRemove) {
        const index = saleItems.findIndex(item =>
            item.product_id === itemToRemove.product_id &&
            item.variant_id === itemToRemove.variant_id &&
            item.description === itemToRemove.description
        );
        if (index > -1) {
            saleItems.splice(index, 1);
            row.remove();
            updateOrderSummary();
        }
    }

    function updateOrderSummary() {
        let totalAmount = saleItems.reduce((sum, item) => sum + item.amount, 0);
        totalAmountSpan.textContent = totalAmount.toFixed(2);

        let cashWalletUsed = 0;
        let shoppingWalletUsed = 0;
        let amountPayable = totalAmount;
        const totalShopWalletLimit = saleItems.reduce((sum, item) => sum + item.effective_shop_wallet_limit, 0);

        const discount = parseFloat(discountInput.value) || 0;
        amountPayable = Math.max(amountPayable - discount, 0);

        if (useCashWalletCheckbox.checked && userWalletBalances.cash_wallet > 0) {
            cashWalletUsed = Math.min(amountPayable, userWalletBalances.cash_wallet);
            amountPayable -= cashWalletUsed;
        }

        if (useShoppingWalletCheckbox.checked && userWalletBalances.shopping_wallet > 0) {
            shoppingWalletUsed = Math.min(amountPayable, userWalletBalances.shopping_wallet, totalShopWalletLimit);
            amountPayable -= shoppingWalletUsed;
        }

        summaryTotalAmountSpan.textContent = totalAmount.toFixed(2);
        summaryCashWalletSpan.textContent = cashWalletUsed.toFixed(2);
        summaryShoppingWalletSpan.textContent = shoppingWalletUsed.toFixed(2);
        summaryAmountPayableSpan.textContent = amountPayable.toFixed(2);
    }

    async function placeOrder() {
        if (!activeUserId) return alert('Please enter and validate customer User ID.');
        if (saleItems.length === 0) return alert('Please add products to the sale before placing an order.');

        const totalAmount = parseFloat(summaryTotalAmountSpan.textContent);
        const cashWalletUsed = parseFloat(summaryCashWalletSpan.textContent);
        const shoppingWalletUsed = parseFloat(summaryShoppingWalletSpan.textContent);
        const amountPayable = parseFloat(summaryAmountPayableSpan.textContent);
        const discount = parseFloat(discountInput.value) || 0;
        const paymentMode = finalPaymentMethodSelect.value;
    const adminRole = adminRoleField ? adminRoleField.value.trim() : '';
    console.log('Admin role to send:', adminRole);

    if (!adminRole) {
        alert('Admin role is missing. Please check your page or login again.');
        return;
    }

        const orderData = {
            user_id: activeUserId,
            items: saleItems.map(item => ({
                product_id: item.product_id,
                variant_id: item.variant_id,
                sell_price: item.sell_price,
                quantity: item.quantity,
                amount: item.amount,
                shop_wallet_value: item.shop_wallet_value,
                description: item.description || ''
            })),
            total_amount: totalAmount,
            cash_wallet_used: cashWalletUsed,
            shopping_wallet_used: shoppingWalletUsed,
            discount: discount,
            amount_payable: amountPayable,
            payment_mode: paymentMode,
            //  admin_role: adminRoleField.value, 
               admin_role: adminRole,
            _token: '{{ csrf_token() }}'
        };

        try {
            const response = await fetch('/admin/place_offlineorder', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify(orderData)
            });

            const data = await response.json();
            if (response.ok) {
                alert(data.message + ` Order ID: ${data.order_id}`);
                window.open(`/admin/generateInvoice/${data.order_id}`, '_blank');
                resetAllFormFields();
            } else {
                let errorMessage = data.message || 'Failed to place order.';
                if (data.errors) {
                    errorMessage += '\n' + Object.values(data.errors).flat().join('\n');
                }
                alert(errorMessage);
            }
        } catch (error) {
            console.error('Error placing order:', error);
            alert('An unexpected error occurred while placing the order.');
        }
    }

    function resetAllFormFields() {
        userIdField.value = '';
        fetchUserAndWalletDetails();

        resetProductFields();
        saleItems = [];
        saleItemsTable.innerHTML = '';
        totalAmountSpan.textContent = '0.00';
        discountInput.value = '';
        useCashWalletCheckbox.checked = false;
        useShoppingWalletCheckbox.checked = false;
        finalPaymentMethodSelect.value = 'cash';
        updateOrderSummary();
    }

    updateOrderSummary();
</script>


 @endsection
