@extends('admin.layouts')
@section('title', 'Recent Orders')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



<div class="container-fluid page-wrapper">



    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Shiprocket Orders</h3>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-3">
            <label for="fromDate">From Date</label>
            <input type="date" id="fromDate" class="form-control">
        </div>
        <div class="col-md-3">
            <label for="toDate">To Date</label>
            <input type="date" id="toDate" class="form-control">
        </div>
        <div class="col-md-3">
            <button id="filterBtn" class="btn btn-primary mt-4">Filter</button>
            <button id="resetBtn" class="btn btn-secondary mt-4 ml-2">Reset</button>
        </div>
    </div>

  

    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="card datatable-card">
                <div class="card-body">
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>ORDER DATE</th>
                                <th>BILL ID</th>
                                <th>USER DETAILS</th>
                                <th>CATEGORY</th>
                                <th>SUBCATEGORY</th>
                                <th>PRODUCT DETAILS</th>
                                <th>AMOUNT</th>
                                <th>ADDRESS</th>
                                 <th>ACTION</th> 
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($recent_orders as $key => $recent_order)
                            <tr data-order-date="{{ \Carbon\Carbon::parse($recent_order->order_date)->format('YYYY-MM-DD') }}">
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ \Carbon\Carbon::parse($recent_order->order_date)->format('d-m-Y') }}</td>
                                <td>{{ $recent_order->order_random_id }}</td>
                                <td>
                                    <div>User ID: {{ $recent_order->user_id ?? 'NA' }}</div>
                                    <div>{{ $recent_order->user_name }}</div>
                                </td>

                                <td>
                                    @php
                                        $categories = json_decode($recent_order->category_name, true) ?? explode('~', $recent_order->category_name);
                                        $subcategories = json_decode($recent_order->subcategory_name, true) ?? explode('~', $recent_order->subcategory_name);
                                        $product_details_name=json_decode($recent_order->product_details_name, true) ?? explode('~', $recent_order->product_details_name);
                                    @endphp

                                    {{ implode(', ', $categories) }}
                                </td>
                                <td>
                                    {{ implode(', ', $subcategories) }}
                                </td>
                                <td>{{ implode(', ', $product_details_name) }}
                                </td>

                                <td><span>₹{{ $recent_order->amount }}</span></td>
                                {{-- <td>{{ $recent_order->delivery_address }}</td> --}}
  <td>{{ Str::limit($recent_order->delivery_address, 25, '...') }}</td>
<td>
                <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#shipModal{{ $recent_order->id }}">Ship</button>
                <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#cancelModal{{ $recent_order->id }}">Cancel</button>
            </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>


                </div>
            </div>
        </div>
    </div>
    </div>

    <!-- Table Row Ends -->
    <!-- end container fluid -->



 {{-- Ship Modal --}}
        <div class="modal fade" id="shipModal{{ $recent_order->id }}" tabindex="-1" aria-labelledby="shipModalLabel{{ $recent_order->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Ship Order</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to mark this order as <strong>Shipped</strong>?
                    </div>
                    <div class="modal-footer">
                        <form action="" method="POST">
                            @csrf
                            <button type="submit" class="btn btn-success">Yes, Ship</button>
                        </form>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
        </div>

        {{-- Cancel Modal --}}
        <div class="modal fade" id="cancelModal{{ $recent_order->id }}" tabindex="-1" aria-labelledby="cancelModalLabel{{ $recent_order->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Cancel Order</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to <strong>Cancel</strong> this order?
                    </div>
                    <div class="modal-footer">
                        <form action="" method="POST">
                            @csrf
                            <button type="submit" class="btn btn-danger">Yes, Cancel</button>
                        </form>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Back</button>
                    </div>
                </div>
            </div>
        </div>
@endsection
@section('footer')


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    
    <script>
        $(document).ready(function () {
            let table = $('#data-table').DataTable({
                responsive: true
            });
    
            // Custom date filter function
            $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
                let fromDate = $('#fromDate').val();
                let toDate = $('#toDate').val();
                let orderDate = data[1]; // ORDER DATE column (index 1)
    
                let momentDate = moment(orderDate, 'D-M-YYYY');
    
                if (fromDate && !momentDate.isSameOrAfter(fromDate, 'day')) {
                    return false;
                }
    
                if (toDate && !momentDate.isSameOrBefore(toDate, 'day')) {
                    return false;
                }
    
                return true;
            });
    
            // Filter button event
            $('#filterBtn').on('click', function () {
                table.draw();
            });
    
            // Reset button event
            $('#resetBtn').on('click', function () {
                $('#fromDate').val('');
                $('#toDate').val('');
                table.draw();
            });
        });
    </script>


@endsection
