@extends('admin.layouts')
@section('title', 'User Management')

@section('header')
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
@endsection

@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Shopping Wallet Transaction </h3>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
                </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="fromDate">From Date:</label>
                    <input type="date" class="form-control" id="fromDate">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="toDate">To Date:</label>
                    <input type="date" class="form-control" id="toDate">
                </div>
            </div>
            <div class="col-md-6 d-flex align-items-end justify-content-end">
                <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                <button class="btn btn-secondary" id="resetBtn">Reset</button>
            </div>
        </div>
        <!-- Total Amount Display -->
        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <span id="totalAmount" class="h5">Total Amount:</span>
            </div>
        </div>

        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>DATE</th>
                                    <th>NAME</th>
                                    <th>USER ID</th>
                                    <th>NUMBER</th>
                                    <th>Type</th>
                                    <th>AMOUNT</th>
                                     <th>Remark</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($shopWalletIncomes as $index => $shopWalletIncome)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $shopWalletIncome->created_at->format('Y-m-d H:i:s') }}</td>
                                        <td>{{ optional($shopWalletIncome->user)->name ?? 'N/A' }}</td>
                                        <td>{{ optional($shopWalletIncome->user)->user_id ?? 'N/A' }}</td>
                                        <td>{{ optional($shopWalletIncome->user)->phone_number ?? 'N/A' }}</td>
                                        <td>{{ $shopWalletIncome->type ?? 'N/A' }}</td>
                                        <td>{{ number_format($shopWalletIncome->amount, 2) }}</td>
                                        <td>{{ $shopWalletIncome->remark ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->
    </div>
@endsection

@section('footer')
    <!-- Bootstrap Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- JQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Moment.js for date filtering -->
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>

    <!-- Datatables JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

    <script>
        $(document).ready(function() {
            let table = $('#data-table').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'excelHtml5',
                    text: 'Export to Excel',
                    filename: 'Shopping_Wallet_Transactions',
                    title: null,
                    className: 'd-none',
                    exportOptions: {
                        columns: ':visible'
                    }
                }],
                responsive: true
            });

            // Function to calculate the total amount for filtered rows
            function calculateTotalAmount() {
                let totalAmount = 0;

                // Loop through the filtered rows and calculate the sum
                table.rows({
                    filter: 'applied'
                }).every(function() {
                    let data = this.data();
                    let amount = parseFloat(data[6].replace(/,/g, '')); // AMOUNT column (index 6)
                    totalAmount += isNaN(amount) ? 0 : amount;
                });

                // Display the total amount
                $('#totalAmount').text('Total Amount: ' + totalAmount.toFixed(2));
            }

            // Filter date range
            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                let fromDate = $('#fromDate').val();
                let toDate = $('#toDate').val();
                let dateStr = data[1]; // DATE column

                if (!fromDate && !toDate) return true;

                let rowDate = moment(dateStr, 'YYYY-MM-DD HH:mm:ss');

                let start = fromDate ? moment(fromDate, 'YYYY-MM-DD') : null;
                let end = toDate ? moment(toDate, 'YYYY-MM-DD') : null;

                if (start && !end && rowDate.isSameOrAfter(start, 'day')) return true;
                if (!start && end && rowDate.isSameOrBefore(end, 'day')) return true;
                if (start && end && rowDate.isBetween(start, end, 'day', '[]')) return true;

                return false;
            });

            // Button events
            $('#filterBtn').on('click', function() {
                table.draw();
                calculateTotalAmount(); // Calculate and display the total amount after filter
            });

            $('#resetBtn').on('click', function() {
                $('#fromDate').val('');
                $('#toDate').val('');
                table.draw();
                calculateTotalAmount(); // Recalculate the total amount when reset
            });

            $('.excel-btn').on('click', function() {
                table.button('.buttons-excel').trigger();
            });

            // Initial total amount calculation when page loads
            calculateTotalAmount();
        });
    </script>
@endsection
