@extends('admin.layouts')
@section('title', 'Stock Details')
@section('head')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
@endsection
@section('content')
    {{-- <div class="container-fluid page-wrapper category-container">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="page-title">Stock Details</h2>
        </div>
        <div class="d-flex justify-content-between align-items-center mb-3">
        </div>
        <div class="card shadow-sm">
            <div class="card-body">
           <table id="stock-details-table" class="table table-hover responsive nowrap" style="width:100%">
   <thead>
        <tr>
            <th>S.No</th>
            <th>Date</th>
            <th>Transaction Type</th>
            <th>Quantity</th>
            <th>Invoice / Order</th>
            <th>Closing Stock</th>
        </tr>
    </thead>
       <tbody>
    @php $closing_stock = 0; @endphp
    @foreach ($transactions as $transaction)
        @if ($transaction['type'] == 'Purchase')
            @if ($closing_stock <= 0)
                @php $closing_stock = $transaction['quantity']; @endphp
            @else
                @php $closing_stock += $transaction['quantity']; @endphp
            @endif
        @else
            @php $closing_stock -= $transaction['quantity']; @endphp
        @endif
        @php
            $display_stock = $closing_stock < 0 ? 0 : $closing_stock;
        @endphp
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ \Carbon\Carbon::parse($transaction['date'])->format('Y-m-d') }}</td>
            <td>
                @if ($transaction['type'] == 'Purchase')
                    <span class="badge bg-success">Purchase</span>
                @else
                    <span class="badge bg-danger">Sale</span>
                @endif
            </td>
            <td>{{ $transaction['quantity'] }}</td>
            <td>{{ $transaction['ref'] }}</td>
            <td>{{ $display_stock }}</td>
        </tr>
    @endforeach
</tbody>
</table>
            </div>
        </div>
    </div> --}}

<div class="container-fluid page-wrapper category-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="page-title">Stock Details for {{ $product->title ?? 'Product' }}</h2>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <table id="stock-details-table" class="table table-hover responsive nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Date & Time</th>
                        <th>Transaction Type</th>
                        <th>Quantity</th>
                        <th>Invoice / Order</th>
                        <th>Closing Stock</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        // Ensure we have a collection to work with
                        $sortedTransactions = $transactions ?? collect();

                        $calculated_stock_from_history = 0;
                        $stockHistory = [];
                        
                        // --- STEP 1: Calculate Total Stock from History ---
                        // Iterate through the ASCENDING sorted list to find the running total
                        foreach ($sortedTransactions as $t) {
                            $quantity = (int) $t['quantity'];
                            if ($t['type'] === 'Purchase' || $t['type'] === 'Admin Add') {
                                $calculated_stock_from_history += $quantity;
                            } elseif ($t['type'] === 'Sale' || $t['type'] === 'Admin Reduce') {
                                $calculated_stock_from_history -= $quantity;
                            }
                        }
                        
                        // --- STEP 2: Determine the Initial Stock Offset ---
                        // The difference between the actual stock (68) and the historical total (e.g., 60 or 61).
                        $initial_stock_offset = $product->stock - $calculated_stock_from_history;
                        
                        // Initialize the running closing stock with the offset.
                        $closing_stock = $initial_stock_offset;
                        
                        // --- STEP 3: Calculate Running Closing Stock with Offset ---
                        // If there's a positive offset, we first add a virtual 'Initial Stock' transaction
                        if ($initial_stock_offset > 0) {
                            // Find the date of the very first recorded transaction
                            $firstTransactionDate = $sortedTransactions->first() ? 
                                \Carbon\Carbon::parse($sortedTransactions->first()['date'])->subSecond() : 
                                now();

                            $stockHistory[] = [
                                'date' => $firstTransactionDate->format('Y-m-d H:i:s'),
                                'type' => 'Initial Stock',
                                'quantity' => $initial_stock_offset,
                                'ref' => 'System Offset',
                                'closing_stock' => $initial_stock_offset,
                            ];
                        }
                        
                        // Now process the actual database transactions
                        foreach ($sortedTransactions as $t) {
                            $quantity = (int) $t['quantity'];

                            // Update running closing stock
                            if ($t['type'] === 'Purchase' || $t['type'] === 'Admin Add') {
                                $closing_stock += $quantity;
                            } elseif ($t['type'] === 'Sale' || $t['type'] === 'Admin Reduce') {
                                $closing_stock -= $quantity;
                            }

                            // Ensure stock doesn't drop below zero
                            $closing_stock = max(0, $closing_stock);
                            
                            $stockHistory[] = array_merge($t, [
                                'closing_stock' => $closing_stock,
                            ]);
                        }

                        // --- STEP 4: Sort descending for display (latest first) ---
                        $stockHistory = collect($stockHistory)->sortByDesc(function($t) {
                            return \Carbon\Carbon::parse($t['date'])->timestamp;
                        })->values();
                    @endphp

                    {{-- Loop through the final, descending history array --}}
                    @foreach ($stockHistory as $transaction)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ \Carbon\Carbon::parse($transaction['date'])->format('Y-m-d H:i:s') }}</td>
                            <td>
                                @if ($transaction['type'] == 'Purchase')
                                    <span class="badge bg-success">Purchase</span>
                                @elseif ($transaction['type'] == 'Sale')
                                    <span class="badge bg-danger">Sale</span>
                                @elseif ($transaction['type'] == 'Admin Add')
                                    <span class="badge bg-warning text-dark">Admin Add</span>
                                @elseif ($transaction['type'] == 'Admin Reduce')
                                    <span class="badge bg-warning text-dark">Admin Reduce</span>
                                @elseif ($transaction['type'] == 'Initial Stock')
                                    <span class="badge bg-primary">Initial Stock</span>
                                @endif
                            </td>
                            <td>
                                {{-- Display quantity change with sign --}}
                                @if ($transaction['type'] == 'Admin Add' || $transaction['type'] == 'Initial Stock' || $transaction['type'] == 'Purchase')
                                    <span class="text-success">+{{ $transaction['quantity'] }}</span>
                                @elseif ($transaction['type'] == 'Admin Reduce' || $transaction['type'] == 'Sale')
                                    <span class="text-danger">-{{ $transaction['quantity'] }}</span>
                                @else
                                    {{ $transaction['quantity'] }}
                                @endif
                            </td>
                            <td>{{ $transaction['ref'] ?? '-' }}</td>
                            <td>{{ $transaction['closing_stock'] }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>



@endsection
@section('footer')
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/responsive.bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#stock-details-table').DataTable({
                responsive: true,
                searching: false,
                paging: false,
                info: false
            });
        });
    </script>
    
@endsection
