@extends('admin.layouts')
@section('title', 'stock summary')
@section('header')
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/responsive.bootstrap.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/buttons.dataTables.min.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
    <style>
        table td,
        table th {
            vertical-align: middle;
            white-space: normal !important;
        }
    </style>
@endsection
@section('content')
    @php
        $totalPurchaseValue = 0;
        $totalSalesValue = 0;
        foreach ($products as $product) {
            $totalPurchaseValue += ($product->purchase_price ?? 0) * ($product->stock ?? 0);
            $totalSalesValue += ($product->sell_price ?? 0) * ($product->stock ?? 0);
        }
    @endphp
    <div class="container-fluid page-wrapper category-container">
        <div class="row mb-3">
            <div class="col-12">
                <h2 class="page-title">Stock Summary</h2>
            </div>
        </div>
        <div class="row mb-3" id="totalsRow">
            <div class="col-md-3">
                <div class="card bg-light">
                <div class="card-body p-2">
    <strong>Total Purchase Value: <span id="totalPurchaseValue">{{ number_format($totalPurchaseValue, 2) }}</span></strong>
</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-light">
                 <div class="card-body p-2">
    <strong>Total Sales Value: <span id="totalSalesValue">{{ number_format($totalSalesValue, 2) }}</span></strong>
</div>
                </div>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-3">
                <select id="categoryFilter" class="form-select">
                    <option value="">All Categories</option>
                    @foreach ($products->pluck('category_name')->unique() as $category)
                        <option value="{{ $category }}">{{ $category }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <select id="subcategoryFilter" class="form-select"> <!-- ✅ fixed ID -->
                    <option value="">All Subcategories</option>
                    @foreach ($products->pluck('subcategory_name')->unique() as $subcategory)
                        <option value="{{ $subcategory }}">{{ $subcategory }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6 text-end">
                <button id="customExcelBtn" class="btn btn-success">
                    <i class="fa-solid fa-file-excel me-2"></i>Export as Excel
                </button>
            </div>
        </div>
        <!-- Table Row -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table table-bordered table-striped align-middle table-responsive"
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>CATEGORY</th>
                                    <th class="d-none d-md-table-cell">SUB CATEGORY</th>
                                    <th>PRODUCT ID</th>
                                    <th style="max-width: 150px;">TITLE</th>
                                     <th style="max-width: 150px;">AGENCY</th>
                                    <th>PURCHASE PRICE</th>
                                    <th>SALES PRICE</th>
                                    <th class="d-none d-md-table-cell">STOCK</th>
                                    <th class="d-none d-md-table-cell">STOCK VALUE</th>
                                    <th class="d-none d-md-table-cell">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($products as $product)
                                    @php
                                        $stockValue = ($product->sell_price ?? 0) * ($product->stock ?? 0);
                                    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $product->category_name ?? 'N/A' }}</td>
                                        <td class="d-none d-md-table-cell">{{ $product->subcategory_name ?? 'N/A' }}</td>
                                        <td>{{ $product->product_id ?? 'N/A' }}</td>
                                        <td class="text-truncate" style="max-width: 150px;" title="{{ $product->title }}">
                                            {{ $product->title ?? 'N/A' }}
                                        </td>
                                        <td class="text-truncate" style="max-width: 150px;" title="{{ $product->brand }}">
                                            {{ $product->brand ?? 'N/A' }}
                                        </td>
                                        <td>{{ number_format($product->purchase_price ?? 0, 2) }}</td>
                                        <td>{{ number_format($product->sell_price ?? 0, 2) }}</td>
                                        <td class="d-none d-md-table-cell">{{ $product->stock ?? '0' }}</td>
                                        <td class="d-none d-md-table-cell">{{ number_format($stockValue, 2) }}</td>
                                        <td><a href="{{ route('stock_details', $product->product_id) }}"
                                                class="btn btn-primary btn-sm">
                                                View
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/jquery.dataTables.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.bootstrap5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.responsive.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.buttons.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/buttons.html5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/buttons.print.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/jszip.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/pdfmake.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/vfs_fonts.js') }}"></script>
    {{-- <script>
  $(document).ready(function() {
    var table = $('#data-table').DataTable({
        responsive: true,
        dom: 'lfrtip',
        buttons: [{
            extend: 'excelHtml5',
            title: 'Products',
            exportOptions: {
                modifier: {
                    page: 'all',
                    search: 'applied',
                    order: 'applied'
                }
            }
        }],
        paging: true
    });
    // 🔹 Function to update totals dynamically
    function updateTotals(table) {
        var totalSales = 0;
        var totalPurchase = 0;
        table.rows({ search: 'applied' }).every(function() {
            var data = this.data();
            var purchasePrice = parseFloat(data[5].replace(/,/g, '')) || 0; // PURCHASE PRICE col
            var salesPrice = parseFloat(data[6].replace(/,/g, '')) || 0;    // SALES PRICE col
            var stock = parseFloat(data[7].replace(/,/g, '')) || 0;         // STOCK col
            totalPurchase += purchasePrice * stock;
            totalSales += salesPrice * stock;
        });
        // Update HTML
        $('#totalPurchaseValue').text(totalPurchase.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }));
        $('#totalSalesValue').text(totalSales.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }));
    }
    // Initial load
    updateTotals(table);
    // 🔹 On Category filter
    $('#categoryFilter').on('change', function() {
        var val = this.value;
        table.column(1).search(val ? '^' + val + '$' : '', true, false).draw();
        updateTotals(table);
    });
    // 🔹 On Subcategory filter
    $('#subcategoryFilter').on('change', function() {
        var val = this.value;
        table.column(2).search(val ? '^' + val + '$' : '', true, false).draw();
        updateTotals(table);
    });
    // 🔹 On reset
    $('#allProductsBtn').on('click', function() {
        $('#categoryFilter').val('');
        $('#subcategoryFilter').val('');
        table.search('').columns().search('').draw();
        updateTotals(table);
    });
});
    </script> --}}
    <script>
$(document).ready(function() {
    var table = $('#data-table').DataTable({
        responsive: true,
        dom: 'lfrtip',
        buttons: [{
            extend: 'excelHtml5',
            title: 'Products',
            exportOptions: {
                modifier: {
                    page: 'all',
                    search: 'applied',
                    order: 'applied'
                }
            }
        }],
        paging: true
    });
    // 🔹 Function to update totals dynamically (for ALL filtered rows, across ALL pages)
    function updateTotals(table) {
        var totalSales = 0;
        var totalPurchase = 0;
        // ✅ Use { search: 'applied' } + { page: 'all' } to include all pages
        table.rows({ search: 'applied', page: 'all' }).every(function() {
            var data = this.data();
            // Adjust indexes to your actual columns
            var purchasePrice = parseFloat(data[6].replace(/,/g, '')) || 0; // PURCHASE PRICE
            var salesPrice = parseFloat(data[7].replace(/,/g, '')) || 0;    // SALES PRICE
            var stock = parseFloat(data[8].replace(/,/g, '')) || 0;         // STOCK
            totalPurchase += purchasePrice * stock;
            totalSales += salesPrice * stock;
        });
        // Update the HTML values
        $('#totalPurchaseValue').text(totalPurchase.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }));
        $('#totalSalesValue').text(totalSales.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }));
    }
    // Initial load
    updateTotals(table);
    // 🔹 Recalculate on search, pagination, or filter change
    table.on('draw search', function() {
        updateTotals(table);
    });
    // 🔹 On Category filter
    $('#categoryFilter').on('change', function() {
        var val = this.value;
        table.column(1).search(val ? '^' + val + '$' : '', true, false).draw();
    });
    // 🔹 On Subcategory filter
    $('#subcategoryFilter').on('change', function() {
        var val = this.value;
        table.column(2).search(val ? '^' + val + '$' : '', true, false).draw();
    });
    // 🔹 On reset
    $('#allProductsBtn').on('click', function() {
        $('#categoryFilter').val('');
        $('#subcategoryFilter').val('');
        table.search('').columns().search('').draw();
    });
});
</script>
@endsection
