<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms & Conditions – AdBazzar</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.7;
            color: #343a40;
            background-color: #f8f9fa;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Montserrat', sans-serif;
            color: #138FA6 !important;
        }
        .container {
            flex: 1;
            background-color: #ffffff;
            border-radius: 0.75rem;
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.08);
            padding: 2.5rem;
            margin-top: 3rem;
            margin-bottom: 3rem;
        }
        .header-title {
            font-size: clamp(2rem, 4vw, 3rem);
            font-weight: 700;
            margin-bottom: 2.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #e9ecef;
        }
        .section-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 0.75rem;
            font-size: 1.6em;
            color: #138FA6;
        }
        p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }
        ol {
            list-style-type: none; /* Remove default numbering */
            padding-left: 0;
        }
        ol > li { /* Target direct children of ol */
            margin-bottom: 2.5rem; /* Space between major policy points */
        }
        ul { /* For nested lists within cards */
            list-style-type: none;
            padding-left: 0;
            margin-top: 1rem;
        }
        ul li {
            margin-bottom: 0.6rem;
            font-size: 1.05rem;
            position: relative;
            padding-left: 1.8rem;
        }
        ul li::before {
            content: "\f05a"; /* Bootstrap icon for info-circle */
            font-family: "bootstrap-icons";
            color: #138FA6;
            font-weight: bold;
            display: inline-block;
            position: absolute;
            left: 0;
            top: 0.1em;
            font-size: 1.1em;
        }
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.05);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            padding: 2rem; /* Consistent padding inside cards */
        }
        .card:hover {
            transform: translateY(-0.25rem);
            box-shadow: 0 0.5rem 1.25rem rgba(0, 0, 0, 0.09);
        }
        .footer {
            margin-top: 3rem;
            padding: 1.5rem;
            text-align: center;
            color: #6c757d;
            font-size: 0.875rem;
            background-color: #e9ecef;
            border-top: 1px solid #dee2e6;
        }

        /* Responsive adjustments */
        @media (max-width: 767.98px) {
            .container {
                margin-top: 1.5rem;
                margin-bottom: 1.5rem;
                padding: 1.5rem;
                border-radius: 0;
                box-shadow: none;
            }
            .header-title {
                font-size: 1.8rem;
                text-align: center;
                margin-bottom: 2rem;
            }
            .section-title {
                font-size: 1.5rem;
                justify-content: center;
                text-align: center;
            }
            ul li {
                padding-left: 1.5rem;
            }
            ul li::before {
                font-size: 1em;
                left: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="header-title text-center">Terms & Conditions – AdBazzar</h1>
        <div class="card p-4 mb-4 animate__animated animate__fadeIn">
            <p>Welcome to AdBazzar. By accessing or using our mobile application, you agree to abide by the following terms and conditions. Please read them carefully, as they govern your use of our services.</p>
        </div>

        <ol>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-box-seam-fill"></i>Product Policies:</h2>
                    <ul class="list-unstyled">
                        <li>Warranty is <strong>void</strong> if the product is wet, physically damaged, or tampered with.</li>
                        <li>Only the <strong>manufacturer's conditional warranty</strong> applies to eligible products. AdBazzar facilitates but does not directly provide manufacturer warranties.</li>
                        <li>The respective manufacturing company is solely responsible for product warranties and their fulfillment.</li>
                        <li>For warranty-related service, users must visit the manufacturer’s authorized service center within the specified warranty period.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-cash-stack"></i>Refund & Replacement Policy:</h2>
                    <ul class="list-unstyled">
                        <li>In case a product is not received due to a failed delivery attempt, the refund will be processed after the item is successfully returned to our facility.</li>
                        <li>If the customer receives a <strong>damaged or defective product</strong>, they must send clear photos and a description of the issue to our admin team <strong>within 2 days of delivery</strong>.</li>
                        <li>Replacement will only be accepted if the product is found genuinely defective and matches the product originally delivered by AdBazzar.</li>
                        <li><strong>No replacement will be provided</strong> if the returned product is altered, used beyond inspection, or differs significantly from what was originally delivered.</li>
                        <li>For genuine cases, replacements will be processed and shipped within <strong>3–7 business days</strong> or can be exchanged immediately at our designated AdBazzar offline store.</li>
                        <li>A delivery charge of <strong>₹80</strong> will apply for orders below <strong>₹1000</strong>.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-person-badge-fill"></i>Membership Policy:</h2>
                    <p>AdBazzar does not enforce mandatory membership subscriptions. Users may voluntarily choose to join our <strong>Membership Plan</strong> to unlock exclusive benefits.</p>
                    <p>Upon joining, members earn wallet rewards through simple daily tasks. These rewards can be used to partially offset product prices (<strong>10%–50%</strong>) within the app, significantly reducing out-of-pocket expenses. Membership is entirely optional and not required for general app usage or product purchases.</p>
                    <p>Our app also provides an optional <strong>withdrawal feature</strong> through which users can manually request payouts of available Cash Wallet amounts. Withdrawals are processed manually upon admin approval, ensuring transparency and preventing misuse.</p>
                    <p>All financial features operate under clear terms and policies available in-app. <strong>We do not promote any gambling, Ponzi schemes, or misleading earning models.</strong> All product purchases, rewards, and withdrawal mechanisms are legitimate, transparent, and designed for utility and savings.</p>
                    <p class="text-muted small">This system was built to empower users—especially homemakers—to save while shopping and optionally earn through verified tasks, contributing to practical household savings.</p>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-wallet-fill"></i>Payment Terms:</h2>
                    <ul class="list-unstyled">
                        <li>All payments are securely processed via our trusted payment gateway partner, <strong>Razorpay</strong>.</li>
                        <li>For your security and privacy, <strong>we do not store users’ card, bank, or UPI details on our servers.</strong></li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-file-earmark-person-fill"></i>User Responsibilities:</h2>
                    <ul class="list-unstyled">
                        <li>Users are solely responsible for maintaining the confidentiality of their login credentials.</li>
                        <li>Any activity performed through their account will be considered as performed by the user themselves. Please ensure your account details are kept secure.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-slash-circle-fill"></i>Prohibited Activities:</h2>
                    <ul class="list-unstyled">
                        <li>Users shall not use the app for any illegal, fraudulent, harassing, or harmful purposes, including but not limited to, unauthorized access, data scraping, or malicious activities.</li>
                        <li>Misuse of the platform, violation of these terms, or any activity that harms AdBazzar or its users may lead to immediate suspension or permanent ban of the account without prior notice.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-shield-fill-check"></i>Limitation of Liability:</h2>
                    <ul class="list-unstyled">
                        <li>AdBazzar is not responsible for any indirect, incidental, special, or consequential damages arising from the use or inability to use our services.</li>
                        <li>We are not liable for delays, losses, or issues caused by third-party courier or logistic services, though we will assist in resolving such matters to the best of our ability.</li>
                    </ul>
                </div>
            </li>
            <li>
                <div class="card animate__animated animate__fadeInUp">
                    <h2 class="section-title text-center text-md-start"><i class="bi bi-globe-americas"></i>Governing Law & Jurisdiction:</h2>
                    <ul class="list-unstyled">
                        <li>These terms and conditions shall be governed by and construed in accordance with the laws of <strong>India</strong>.</li>
                        <li>Any legal disputes or claims arising from or related to these terms and services shall fall under the exclusive jurisdiction of the courts located in <strong>Erode, Tamil Nadu, India only</strong>.</li>
                    </ul>
                </div>
            </li>
        </ol>
        <p class="mt-4 text-center text-muted">Thank you for choosing AdBazzar. Your trust and satisfaction are paramount to us.</p>
    </div>

    <footer class="footer">
        &copy; 2025 AdBazzar. All rights reserved.
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>