@extends('admin.layouts')

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
@section('content')
    <style>


    </style>




    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex align-items-center">
                <h2 class="page-title mb-0">Update Category</h2>
            </div>
        </div>
        
        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Update Category</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('categories_update', ['id' => $category->id]) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group mb-3 text-center">
                                        <label for="category_img">Current Image:</label>
                                        <input class="form-control d-none" name="category_img" type="file" id="category_img" accept="image/*" onchange="previewImage(event)">
                                        <div class="mt-3">
                                            <label for="category_img" style="cursor: pointer;">
                                                <img id="image_preview" src="{{ asset($category->category_img) }}" alt="Category Image" class="img-thumbnail rounded-circle" style="width: 120px; height: 120px; object-fit: cover;">
                                            </label>
                                            <p class="mt-2">Click on the image to upload a new one</p>
                                            <p>Image must be in 1:1 resolution.</p>
                                        </div>
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="category_type" class="form-label">Select Category Type</label>
                                        <select class="form-select" name="category_type" id="category_type" aria-label="Category Type Select">
                                            <option value="">Select</option>
                                            <option value="1" {{ $category->category_type == 1 ? 'selected' : '' }}>Category</option>
                                            <option value="2" {{ $category->category_type == 2 ? 'selected' : '' }}>Subcategory</option>
                                        </select>
                                    </div>
                                    <div class="form-group mb-3" id="category_name_group">
                                        <label for="category_name" class="form-label">Category Name</label>
                                        <input type="text" name="category_name" class="form-control" id="category_name" placeholder="Enter Name" value="{{ old('category_name', $category->category_name) }}">
                                    </div>
                                    <div class="form-group mb-3" id="subcategory_name_group" style="{{ $category->category_type == 2 ? '' : 'display: none;' }}">
                                        <label for="subcategory_name" class="form-label">Subcategory Name</label>
                                        <input type="text" name="subcategory_name" class="form-control" id="subcategory_name" placeholder="Enter Subcategory Name" value="{{ old('subcategory_name', $category->subcategory_name) }}">
                                    </div>
                                    <div class="form-group mb-3" id="link_to_container" style="{{ $category->category_type == 2 ? '' : 'display: none;' }}">
                                        <label for="link_to" class="form-label">If Type is Subcategory, Link To</label>
                                        <select class="form-select" name="link_to" id="link_to" aria-label="Link To Select">
                                            <option value="">Select</option>
                                            @foreach ($categories->where('category_type', 1) as $cat) {{-- Filter only categories --}}
                                                <option value="{{ $cat->id }}" {{ $category->link_to == $cat->id ? 'selected' : '' }}>
                                                    {{ $cat->category_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Update
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->


    </div>
    <!-- end container fluid -->


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            let categoryType = document.getElementById("category_type");
            let categoryNameGroup = document.getElementById("category_name_group");
            let subcategoryGroup = document.getElementById("subcategory_name_group");
            let linkToContainer = document.getElementById("link_to_container");
        
            function toggleFields() {
                if (categoryType.value == "2") { // If 'Subcategory' is selected
                    categoryNameGroup.style.display = "none"; // Hide Category Name field
                    subcategoryGroup.style.display = "block";
                    linkToContainer.style.display = "block";
                } else { // If 'Category' is selected
                    categoryNameGroup.style.display = "block"; // Show Category Name field
                    subcategoryGroup.style.display = "none";
                    linkToContainer.style.display = "none";
                }
            }
        
            categoryType.addEventListener("change", toggleFields);
            toggleFields(); // Initialize on page load
        
            // Image Preview Function
            window.previewImage = function (event) {
                let reader = new FileReader();
                reader.onload = function () {
                    document.getElementById("image_preview").src = reader.result;
                };
                reader.readAsDataURL(event.target.files[0]);
            };
        });
        </script>
        



@endsection
