@extends('admin.layouts')
@section('title', 'User Profile')
@section('content')
    <div class="container-fluid page-wrapper">
        <div class="row">
            <div class="col-md-12">
                <h3 class="page-top-heading">User Profile</h3>
                   <td>
    <a href="{{ route('user_purchase_history', ['user_id' => $user->user_id]) }}" class="btn btn-sm btn-primary">
        Purchase History
    </a>
</td>
            </div>
        </div>
        <div class="row mt-4">
            <!-- Personal Information -->
            <div class="col-lg-8">
                <div class="card p-3">
                    <div class="card-body">
                        @php
                        $currentAddress = \App\Models\Address::getCurrentAddress($user->id);
                    @endphp
                        <h4>Personal Information</h4>
                        <p><strong>Name:</strong> {{ $user->name }}</p>
                        <p><strong>Email:</strong> {{ $user->email }}</p>
                        <p><strong>Phone Number:</strong> {{ $user->phone_number }}</p>
                        <p><strong>User ID:</strong> {{ $user->user_id }}</p>
                        <p><strong>Address:</strong>
                                @if ($currentAddress && ($currentAddress->building_name || $currentAddress->road_name || $currentAddress->landmark || $currentAddress->district || $currentAddress->state || $currentAddress->pin))
                                    {{ $currentAddress->building_name ?? '' }}
                                    @if ($currentAddress->road_name)
                                        , {{ $currentAddress->road_name }}
                                    @endif
                                    @if ($currentAddress->landmark)
                                        , {{ $currentAddress->landmark }}
                                    @endif
                                    @if ($currentAddress->district)
                                        , {{ $currentAddress->district }}
                                    @endif
                                    @if ($currentAddress->state)
                                        , {{ $currentAddress->state }}
                                    @endif
                                    @if ($currentAddress->pin)
                                        - {{ $currentAddress->pin }}
                                    @endif
                                @else
                                    Address not available
                                @endif
                        </p>
                        <p><strong>Joining Date:</strong>{{ $user->created_at }}</p>
                        <a href="{{ route('toggle_activation', $user->id) }}"
                            class="btn {{ $user->is_active ? 'btn-danger' : 'btn-success' }}">
                            <i class="fa {{ $user->is_active ? 'fa-user-times' : 'fa-user-check' }}"></i>
                            {{ $user->is_active ? 'Deactivate Account' : 'Activate Account' }}
                        </a>
                        <a href="{{ route('edit_user', ['id' => $user->id]) }}" class="btn btn-warning">
                            <i class="fa fa-key"></i> Edit Account
                        </a>
                    </div>
                </div>
                <!-- Wallet Information -->
                <div class="card p-4 mt-3">
                    <div class="card-body">
                        <h4>Wallet Information</h4>
                        <p>
                            <strong>Cash Wallet Balance:</strong> ₹{{ $incomeWallet->cash_wallet ?? '0.00' }}
                            <a href="{{ route('edit_cashwallet', ['id' => $user->id]) }}" class="text-primary">
                                ✏️
                            </a>
                        </p>
                        <p>
                            <strong>Shopping Wallet Balance:</strong> ₹{{ $incomeWallet->shopping_wallet ?? '0.00' }}
                            <a href="{{ route('edit_shoppingwallet', ['id' => $user->id]) }}" class="text-primary">
                                ✏️
                            </a>
                        </p>
                    </div>
                </div>
            </div>
            @if ($user->is_subscribed)
            
                <div class="col-lg-4">
                    <div class="card p-3">
                        <div class="card-body">
                            <h4>Membership Details</h4>
                            
                            <div class="Membership-details d-flex flex-column align-items-center justify-content-center">
                                <img src="{{ asset('/assets') }}/images/member.svg" width="150" height="150" alt="member">
                                <p><strong>Plan Name:</strong> {{ $membership->title ?? 'not subscribed' }}</p>
                                <p><strong>User ID:</strong> {{ $user->user_id }}</p>
                                <p><strong>Membership ID:</strong> {{ $user->membership }}</p>
                            <p><strong>Under User ID:</strong> {{ $user->referral_id ?? 'AdBazzar'}}</p>
                            <p><strong>Status:</strong>
                                <span class="badge {{ $user->is_active ? 'bg-success' : 'bg-danger' }}">
                                    {{ $user->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </p>
                            {{-- <p><strong>Expiry Date:</strong>
                                {{ $user->subscription_end_date ? \Carbon\Carbon::parse($user->subscription_end_date)->format('d/m/Y') : 'N/A' }}
                            </p>
                            <p><strong>Remaining Days:</strong>
                                @if ($user->subscription_end_date)
                                    {{ intval(now()->diffInDays($user->subscription_end_date)) }} Days
                                @else
                                    N/A
                                @endif
                            </p> --}}

                            <p><strong>Expiry Date:</strong>
    {{ $expiryDate->format('d/m/Y') }}
</p>

<p><strong>Remaining Days:</strong>
    {{ $remainingDays > 0 ? $remainingDays . ' Days' : 'Expired' }}
</p>
                        </div>
                        </div>
                    </div>
                </div>
            @endif
<!-- Subscription History -->
@if (!$subscriptions->isEmpty())
    <div class="card p-3 mt-3">
        <div class="card-body">
            <h4>Subscription History</h4>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Plan Name</th>
                        <th>Status</th>
                        <th>Subscribed On</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($subscriptions as $index => $subscription)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $subscription->title ?? 'N/A' }}</td>
                            <td>
                                <span class="badge {{ $subscription->is_active ? 'bg-success' : 'bg-danger' }}">
                                    {{ $subscription->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>{{ \Carbon\Carbon::parse($subscription->created_at)->format('d-m-Y') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@else
    <p class="text-center mt-3">No subscriptions found.</p>
@endif
            <div class="container mt-4">
                <h2 class="text-center">Team</h2>
                <div class="d-flex justify-content-between mb-3">
                    <div>
                        <label>Show
                            <select id="entries" class="form-select d-inline-block w-auto">
                                <option value="10">10</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                            </select>
                            Entries
                        </label>
                    </div>
                    <input type="text" id="search" class="form-control w-25" placeholder="Search">
                </div>
                <div>
                    <table class="table table-bordered table-striped" id="teamTable">
                        <thead class="table">
                            <tr>
                                <th>S/N</th>
                                <th>User ID</th>
                                <th>Name</th>
                                <th>Membership</th>
                                <th>Phone No</th>
                                <th>Created At</th>
                                <th>Expiry Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($referredUsers as $index => $user)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $user->user_id }}</td>
                                    <td>{{ $user->name }}</td>
                                    <td>  {{ $user->membershipRelation ? $user->membershipRelation->title : '-' }}</td>
                                    <td>{{ $user->phone_number }}</td>
                                   <td>{{ \Carbon\Carbon::parse($user->created_at)->format('d-m-Y') }}</td>
                                    <td>{{ \Carbon\Carbon::parse($user->subscription_end_date)->format('d-m-Y') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
