@extends('admin.layouts')
@section('title', 'Recent Orders')
@section('header')

    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')
    <style>
        .col-lg-2 {
            flex: 0 0 auto;
            width: 20%;
        }

        .wrap-text {
            white-space: normal;
            word-break: break-word;
        }

        /* Style for the IMEI/Serial input container */
        .imei-serial-container {
            display: none; /* Hidden by default */
            margin-top: 5px;
        }

        .imei-serial-container input {
            width: calc(100% - 40px); /* Adjust width to fit button */
            display: inline-block;
            vertical-align: middle;
            margin-right: 5px;
        }

        .imei-serial-button {
            cursor: pointer;
        }
    </style>

    <div class="container-fluid page-wrapper">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h3 class="page-top-heading mb-0">Recent Orders</h3>
                <div>
                    @if ($order->status == 'accepted')
                        <span class="btn btn-success me-2">Accepted</span>
                        <a href="#" class="btn btn-primary me-2" onclick="downloadInvoice()">Download Invoice</a>
                        <a href="#" class="btn btn-primary" onclick="printInvoice()">Print Invoice</a>
                    @elseif($order->status == 'rejected')
                        <span class="btn btn-danger">Rejected</span>
                    @else
                        <a href="#" class="btn btn-success me-2"
                            onclick="confirmAccept('{{ route('orders_accept', ['order_random_id' => $order->order_random_id]) }}')">Accept</a>
                        <a href="#" class="btn btn-danger"
                            onclick="confirmReject('{{ route('orders_reject', ['order_random_id' => $order->order_random_id]) }}')">Reject</a>
                    @endif
                </div>
            </div>

            <div class="col-lg-9 pe-lg-4">
                <div class="mb-4">
                    @foreach ($recent_orders as $recent_order)
                        <div class="d-flex justify-content-between align-items-center border-bottom pb-3 mb-3">
                            <div>
                                <h4 class="fw-bold fs-3 mb-1">Order ID: #{{ $recent_order->order_random_id }}</h4>
                                <h5 class="fw-normal fs-6 text-muted mb-0">Placed on:
                                    {{ $recent_order->created_at->format('d-m-Y h:i A') }}</h5>
                            </div>
                            <div>
                                <h5 class="fw-normal fs-6 text-muted mb-0">
                                    @if ($recent_order->status == 'pending')
                                        Payment Status: <span class="text-success fw-bold">Paid</span>
                                    @endif
                                </h5>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="row gx-4 mb-4">
                    <div class="col-lg-6">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body">
                                <h4 class="card-title mb-3">Customer Information</h4>
                                @foreach ($recent_orders as $recent_order)
                                    <p class="mb-2"><strong>Name:</strong> {{ $recent_order->user_name ?? 'N/A' }}</p>
                                    <p class="mb-2"><strong>Email:</strong> {{ $order->user->email ?? 'N/A' }}</p>
                                    <p class="mb-0"><strong>Phone:</strong> {{ $order->user->phone_number ?? 'N/A' }}</p>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6 mt-4 mt-lg-0">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body">
                                <h4 class="card-title mb-3">Shipping Address</h4>
                                @foreach ($recent_orders as $recent_order)
                                    <p class="mb-0">{{ $recent_order->delivery_address }}</p>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card datatable-card shadow-sm">
                    <div class="card-body">
                        <h4 class="card-title mb-3">Order Details</h4>
                        <div class="table-responsive">
                            <table id="data-table" class="table table-hover align-middle" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>S/N</th>
                                        <th>ITEM</th>
                                        <th>IMAGE</th>
                                        <th>QUANTITY</th>
                                        <th>PRODUCT ID</th>
                                        <th>HSN CODE</th>
                                        <th>PRICE</th>
                                        <th>TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        function decodeData($data)
                                        {
                                            if (is_string($data)) {
                                                $decoded = json_decode($data, true);
                                                return is_array($decoded) ? $decoded : explode('~', $data);
                                            }
                                            return [];
                                        }
                                         $global_item_sn = 0;
                                    @endphp

                                    @foreach ($recent_orders as $order_key => $recent_order) {{-- Changed index to order_key --}}
                                        @php
                                            // Decode order details
                                            $product_names = decodeData($recent_order->product_details_name);
                                            $images = json_decode($recent_order->image, true);
                                            $images = is_array($images) ? $images : []; // Ensure it's an array

                                            $quantities = decodeData($recent_order->quantity);
                                            $gst_prices = decodeData($recent_order->gst_price);
                                            $price_details = decodeData($recent_order->price_details);
                                            $variant_ids = decodeData($recent_order->variant_id);
                                            $hsn_codes = decodeData($recent_order->hsn_code);
                                            $product_ids = decodeData($recent_order->product_details_id);
                                            $imei_serial_numbers = json_decode($recent_order->imei_serial_numbers, true) ?? [];
                                        @endphp

                                        @for ($i = 0; $i < count($product_names); $i++)
                                            @php
                                                $global_item_sn++; // Increment for each item row
                                            @endphp
                                            <tr>
                                                <td class="text-center">{{ $global_item_sn }}</td> 
                                                <td style="max-width: 500px; white-space: normal; word-break: break-word;">
                                                    {{ $product_names[$i] ?? 'N/A' }}
                                                    @if (isset($variant_ids[$i]) && $variant_ids[$i] != 'N/A' && $variant_ids[$i] != '')
                                                        <br><small class="text-muted">Variant:
                                                            {{ $variant_ids[$i] }}</small>
                                                    @endif
                                                    <div class="mt-2">
                                                        <span class="badge bg-info text-dark imei-serial-button"
                                                            data-order-detail-id="{{ $recent_order->id }}" 
                                                            data-item-index="{{ $i }}"
                                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                                            title="Click to add/edit IMEI/Serial">
                                                            IMEI/Serial
                                                        </span>
                                                        <div class="imei-serial-container mt-3">
                                                            <input type="text" class="form-control form-control-sm imei-serial-input"
                                                                value="{{ $imei_serial_numbers[$i] ?? '' }}"
                                                                placeholder="Enter IMEI/Serial">
                                                            <button class="btn btn-sm btn-primary mt-3 save-imei-serial-btn">Save</button>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <img src="{{ asset($images[$i] ?? 'assets/images/no-image.png') }}" alt="Product Image"
                                                        width="50" height="50" class="rounded">
                                                </td>
                                                <td class="text-center">{{ $quantities[$i] ?? 0 }}</td>
                                                <td>{{ $product_ids[$i] ?? 'N/A' }}</td>
                                                <td>{{ $hsn_codes[$i] ?? 'N/A' }}</td>
                                                <td>{{ $price_details[$i] ?? 'N/A' }}</td>
                                                <td>{{ number_format(($price_details[$i] ?? 0.0) * ($quantities[$i] ?? 0), 2) }}</td>
                                            </tr>
                                        @endfor
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 mt-4 mt-lg-0">
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <h4 class="card-title mb-3">Order Summary</h4>
                        @foreach ($recent_orders as $recent_order)
                            @php
                                // Decode and multiply price by quantity
                                $price_details = decodeData($recent_order->price_details);
                                $quantities = decodeData($recent_order->quantity);
                                $sub_total = 0;
                                foreach ($price_details as $key => $price) {
                                    $sub_total += $price * ($quantities[$key] ?? 1);
                                }
                            @endphp

                            <p class="d-flex justify-content-between mb-2">
                                <span>Sub Total:</span>
                                <span class="fw-semibold">₹{{ number_format($sub_total, 2) }}</span>
                            </p>
                            <p class="d-flex justify-content-between mb-2">
                                <span>Cash Wallet:</span>
                                <span
                                    class="text-danger fw-semibold">-₹{{ number_format($recent_order->cash_wallet, 2) }}</span>
                            </p>
                            <p class="d-flex justify-content-between mb-2">
                                <span>Shopping Wallet:</span>
                                <span
                                    class="text-danger fw-semibold">-₹{{ number_format($recent_order->shopp_wallet, 2) }}</span>
                            </p>
                            <p class="d-flex justify-content-between mb-2">
                                <span>Delivery Fee:</span>
                                <span
                                    class="text-success fw-semibold">+₹{{ number_format($recent_order->delivery_fee, 2) }}</span>
                            </p>
                            <hr class="my-3">
                            <h5 class="d-flex justify-content-between mb-0">
                                <span>Total:</span>
                                <span class="fw-bold">₹{{ number_format($recent_order->amount, 2) }}</span>
                            </h5>
                        @endforeach
                    </div>
                </div>

                <div class="card shadow-sm">
                    <div class="card-body">
                        <h4 class="card-title mb-3">Tax Calculation</h4>
                        @foreach ($recent_orders as $recent_order)
                            @php
                                $beforeGstValue = 0;
                                $cgst = 0;
                                $sgst = 0;
                                $totalAmount = 0;
                                $is_gst = true;
                                $gst_rate = 18;

                                if ($is_gst && $recent_order->amount > 0 && $gst_rate > 0) {
                                    $beforeGstValue = round($recent_order->amount / (1 + $gst_rate / 100), 2);
                                    $totalGst = round($recent_order->amount - $beforeGstValue, 2);
                                    $cgst = round($totalGst / 2, 2);
                                    $sgst = round($totalGst / 2, 2);
                                    $totalAmount = $recent_order->amount;
                                } else {
                                    $beforeGstValue = $recent_order->amount;
                                    $cgst = 0;
                                    $sgst = 0;
                                    $totalAmount = $recent_order->amount;
                                }
                            @endphp

                            <p class="d-flex justify-content-between mb-2">
                                <span>Before GST Value:</span>
                                <span class="fw-semibold">₹{{ number_format($beforeGstValue, 2) }}</span>
                            </p>
                            <p class="d-flex justify-content-between mb-2">
                                <span>SGST:</span>
                                <span class="fw-semibold">+₹{{ number_format($sgst, 2) }}</span>
                            </p>
                            <p class="d-flex justify-content-between mb-2">
                                <span>CGST:</span>
                                <span class="fw-semibold">+₹{{ number_format($cgst, 2) }}</span>
                            </p>

                            <hr class="my-3">
                            <h5 class="d-flex justify-content-between mb-0">
                                <span>Total (incl. GST):</span>
                                <span class="fw-bold">₹{{ number_format($totalAmount, 2) }}</span>
                            </h5>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        {{-- Modals remain unchanged as their styling is handled by Bootstrap --}}
        <div class="modal fade" id="acceptConfirmationModal" tabindex="-1" aria-labelledby="acceptConfirmationModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="acceptConfirmationModalLabel">Confirm Accept</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to accept this order?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <a href="#" id="acceptOrderLink" class="btn btn-success">Accept Order</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="rejectConfirmationModal" tabindex="-1"
            aria-labelledby="rejectConfirmationModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="rejectConfirmationModalLabel">Confirm Reject</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to reject this order?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <a href="#" id="rejectOrderLink" class="btn btn-danger">Reject Order</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    <script>
        function downloadInvoice() {
            const invoiceWindow = window.open('{{ route('invoice', ['order_random_id' => $order->order_random_id]) }}',
                '_blank');
        }
    </script>

    <script>
        function confirmAccept(url) {
            const acceptModal = new bootstrap.Modal(document.getElementById('acceptConfirmationModal'));
            document.getElementById('acceptOrderLink').href = url;
            acceptModal.show();
        }

        function confirmReject(url) {
            const rejectModal = new bootstrap.Modal(document.getElementById('rejectConfirmationModal'));
            document.getElementById('rejectOrderLink').href = url;
            rejectModal.show();
        }
    </script>
    <script>
        function printInvoice() {
            var invoiceWindow = window.open('{{ route('invoice', ['order_random_id' => $order->order_random_id]) }}',
                '_blank');

            invoiceWindow.onload = function() {
                invoiceWindow.print(); // Automatically triggers the print dialog
            };
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>

    <script>
        $(document).ready(function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
            $(document).on('click', '.imei-serial-button', function() {
                const $button = $(this);
                const $container = $button.next('.imei-serial-container');
                $container.slideToggle(200); 
            });

            $(document).on('click', '.save-imei-serial-btn', function() {
                const $saveButton = $(this);
                const $container = $saveButton.closest('.imei-serial-container');
                const $input = $container.find('.imei-serial-input');
                const imeiSerialNumber = $input.val();

                const $badge = $container.prev('.imei-serial-button');
                const orderDetailId = $badge.data('order-detail-id'); 
                const itemIndex = $badge.data('item-index');
                if (!imeiSerialNumber.trim()) {
                    alert('Please enter an IMEI or Serial Number.');
                    return;
                }

                $.ajax({
                    url: '{{ route('update_imei_serial') }}',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}', 
                        order_id: orderDetailId, 
                        item_index: itemIndex,
                        imei_serial_number: imeiSerialNumber
                    },
                    success: function(response) {
                        if (response.success) {
                            alert(response.message);
                            $container.slideUp(200);
                        } else {
                            alert('Error: ' + response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                        alert('An error occurred while saving the IMEI/Serial number. Please try again.');
                    }
                });
            });
        });
    </script>
@endsection