@extends('admin.layouts')
@section('title', 'Withdrawal History')
@section('header')
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">
@endsection
@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Withdrawal History</h3>
                <div class="d-flex gap-2">
                    <a href="{{ route('accepted_withdraw') }}" class="btn btn-success btn-sm">Accepted Withdrawals</a>
                    <a href="{{ route('rejected_withdraw') }}" class="btn btn-danger btn-sm">Rejected Withdrawals</a>
                </div>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-3">
                <label for="fromDate">From Date</label>
                <input type="date" id="fromDate" class="form-control">
            </div>
            <div class="col-md-3">
                <label for="toDate">To Date</label>
                <input type="date" id="toDate" class="form-control">
            </div>
            <div class="col-md-3">
                <label for="withdrawalType">Withdrawal Type</label>
                <select id="withdrawalType" class="form-control">
                    <option value="">All</option>
                    <option value="gpay">GPay Withdrawal</option>
                    <option value="bank">Bank Withdrawal</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button id="filterBtn" class="btn btn-primary">Filter</button>
                <button id="resetBtn" class="btn btn-secondary">Reset</button>
                <button id="exportBankWithdrawalsBtn" class="btn btn-info excel-btn d-none">Export Bank Withdrawals</button>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>DATE & TIME</th>
                                    <th>Email ID</th>
                                    <th>Amount</th>
                                    <th>Bank Details</th>
                                    <th>Type</th>
                                     {{-- <th>Train Particular</th> --}}
                                    <th>Action</th>
                                    <th class="d-none">Bank Name</th>
                                    <th class="d-none">Account Holder Name</th>
                                    <th class="d-none">Account Number</th>
                                    <th class="d-none">IFSC Code</th>
                                    <th class="d-none">Branch</th>
                                    <th class="d-none">GPay Number</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($withdrawRequests as $key => $request)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $request->created_at->format('m/d/Y H:i:s') }}</td>
                                        <td>{{ $request->user->email ?? 'N/A' }}</td>
                                        <td>₹{{ number_format($request->amount, 2) }}</td>
                                        <td>
                                            @if ($request->type == 'bank' && $request->bankDetails)
                                                <strong>IFSC:</strong> {{ $request->bankDetails->ifsc_code }}<br>
                                                <strong>A/C No:</strong> {{ $request->bankDetails->account_number }}<br>
                                                <strong>Name:</strong> {{ $request->bankDetails->account_holder_name }}<br>
                                                <strong>Bank:</strong> {{ $request->bankDetails->bank_name }}<br>
                                                <strong>Branch:</strong> {{ $request->bankDetails->branch }}
                                            @elseif ($request->type == 'gpay')
                                                <strong>GPay Number:</strong> {{ $request->gpay_number }}
                                            @else
                                                No Details Available
                                            @endif
                                        </td>
                                          {{-- <td>{{ 'NEFT' }}</td> --}}
                                      
                                        <td>{{ ucfirst($request->type) }}</td>
                                        <td>
                                            <a href="#" class="text-success text-decoration-none" data-bs-toggle="modal"
                                                data-bs-target="#AcceptModal" data-user-id="{{ $request->id }}"
                                                onclick="setAcceptId(this)">✅ Accept</a>&nbsp;
                                            <a href="#" class="text-danger text-decoration-none" data-bs-toggle="modal"
                                                data-bs-target="#DeclineModal" data-user-id="{{ $request->id }}"
                                                onclick="setRejectId(this)">❌ Decline</a>
                                        </td>
                                        <td class="d-none">{{ $request->bank_bank_name }}</td>
                                        <td class="d-none">{{ $request->bank_account_holder_name }}</td>
                                        <td class="d-none">{{ $request->bank_account_number }}</td>
                                        <td class="d-none">{{ $request->bank_ifsc_code }}</td>
                                        <td class="d-none">{{ $request->bank_branch }}</td>
                                        <td class="d-none">{{ $request->derived_gpay_number }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade zoom-in" id="AcceptModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body text-center">
                        <img class="mb-3" style="height: 75px;" src="{{ asset('/assets/images/gif/accept.png') }}">
                        <p class="my-4 are-you-sure">Are You Sure</p>
                        <p class="text-muted my-2">Are you sure you want to accept this withdrawal request?</p>
                        <form action="{{ route('accept_withdraw') }}" method="POST">
                            @csrf
                            <input type="hidden" id="accept_id" name="accept_id">
                            <div class="d-flex justify-content-center mt-4">
                                <button type="button" data-bs-dismiss="modal" class="btn btn-light me-2">Cancel</button>
                                <button type="submit" class="btn btn-primary">Yes, Accept It!</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade zoom-in" id="DeclineModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body text-center">
                        <img class="mb-3" style="height:75px;" src="{{ asset('/assets/images/gif/reject.png') }}">
                        <p class="my-4 are-you-sure">Are You Sure</p>
                        <p class="text-muted my-2">Are you sure you want to decline this withdrawal request?</p>
                        <form action="{{ route('reject_withdraw') }}" method="POST">
                            @csrf
                            <input type="hidden" id="reject_id" name="reject_id">
                            <div class="d-flex justify-content-center mt-4">
                                <button type="button" data-bs-dismiss="modal" class="btn btn-light me-2">Cancel</button>
                                <button type="submit" class="btn btn-primary">Yes, Decline It!</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script>
        function setAcceptId(element) {
            document.getElementById("accept_id").value = element.getAttribute("data-user-id");
        }
    
        function setRejectId(element) {
            document.getElementById("reject_id").value = element.getAttribute("data-user-id");
        }
    
        $(document).ready(function() {
            let table = $('#data-table').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'excelHtml5',
                    text: 'Export All',
                    filename: 'Withdraw_History',
                    title: null,
                    className: 'd-none export-all-btn',
                    exportOptions: {
                        columns: ':visible:not(.not-export)'
                    }
                }, {
                    extend: 'excelHtml5',
                    text: 'Export Bank Withdrawals',
                    filename: 'Bank_Withdrawals',
                    title: null,
                    className: 'export-bank-btn d-none', // Make this initially hidden
                    exportOptions: {
                        columns: [ 3, 7, 8, 9, 10, 11], // DATE & TIME, Email ID, Request Amount, Bank Details Columns
                        modifier: {
                            search: 'applied'
                        }
                    }
                }],
                responsive: true
            });
    
            // Custom filter function
            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                let fromDate = $('#fromDate').val();
                let toDate = $('#toDate').val();
                let withdrawalType = $('#withdrawalType').val();
                let date = data[1]; // DATE & TIME column
                let type = data[5]; // Type column
    
                let momentDate = moment(date, 'M/D/YYYY H:i:s');
    
                if (fromDate && !momentDate.isSameOrAfter(fromDate, 'day')) {
                    return false;
                }
    
                if (toDate && !momentDate.isSameOrBefore(toDate, 'day')) {
                    return false;
                }
    
                if (withdrawalType && type.toLowerCase() !== withdrawalType) {
                    return false;
                }
    
                return true;
            });
    
            // Filter button event
            $('#filterBtn').on('click', function() {
                table.draw();
                // Show/hide the "Export Bank Withdrawals" button based on the filter
                if ($('#withdrawalType').val() === 'bank') {
                    $('#exportBankWithdrawalsBtn').removeClass('d-none');
                } else {
                    $('#exportBankWithdrawalsBtn').addClass('d-none');
                }
            });
    
            // Reset button event
            $('#resetBtn').on('click', function() {
                $('#fromDate').val('');
                $('#toDate').val('');
                $('#withdrawalType').val('');
                table.draw();
                $('#exportBankWithdrawalsBtn').addClass('d-none'); // Hide export button on reset
            });
    
            // Event listener for the "Export Bank Withdrawals" button (now directly triggers the DataTables button)
            $('#exportBankWithdrawalsBtn').on('click', function() {
                table.button('.export-bank-btn').trigger();
            });
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
@endsection